/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock.pessimistic;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class LockUpgradeTest {
    private TransactionManager tm;
    private CacheImpl cache;

    @BeforeMethod(alwaysRun=true)
    protected void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(c);
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() throws Exception {
        this.cache.stop();
        this.cache.destroy();
    }

    public void testLock() throws Exception {
        ArrayList<WorkThread> threads = new ArrayList<WorkThread>();
        for (int x = 0; x < 2; ++x) {
            WorkThread t = new WorkThread(x == 1);
            threads.add(t);
            t.start();
        }
        for (WorkThread separateThread : threads) {
            separateThread.join();
            if (separateThread.getException() == null) continue;
            throw separateThread.getException();
        }
    }

    private class WorkThread
    extends Thread {
        Exception e = null;
        private boolean remove;

        public WorkThread(boolean remove) {
            this.remove = remove;
        }

        public Exception getException() {
            return this.e;
        }

        public void run() {
            try {
                for (int x = 0; x < 1000; ++x) {
                    LockUpgradeTest.this.tm.begin();
                    if (this.remove) {
                        LockUpgradeTest.this.cache.remove("/a/b/c/d");
                        LockUpgradeTest.this.cache.remove("/a");
                    } else {
                        LockUpgradeTest.this.cache.put("/a/b/c/d", (Object)"key", (Object)("text" + x));
                    }
                    LockUpgradeTest.this.tm.commit();
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }
}

