/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshallerTestBase;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheMarshaller200Test
extends CacheMarshallerTestBase {
    public CacheMarshaller200Test() {
        this.currentVersion = "2.0.0.GA";
        this.currentVersionShort = 20;
        this.expectedMarshallerClass = CacheMarshaller200.class;
    }

    public void testHandle140Stream() throws Exception {
        VersionAwareMarshaller marshallerOld = new VersionAwareMarshaller(new RegionManager(), false, false, "1.4.0.GA");
        byte[] buf = marshallerOld.objectToByteBuffer((Object)"hello");
        Object unmarshalled = this.marshaller.objectFromByteBuffer(buf);
        AssertJUnit.assertEquals((Object)"hello", (Object)unmarshalled);
    }

    public void testRegionalisedStream() throws Exception {
        CacheMarshaller200 cm200 = new CacheMarshaller200(new RegionManager(), false, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        cm200.objectToObjectStream((Object)"Hello World", oos, Fqn.fromString((String)"/hello"));
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        byte magic = ois.readByte();
        short ref = ois.readShort();
        System.out.println("Magic number is " + magic);
        assert (magic == 2);
        Fqn f = cm200.unmarshallFqn(ois, new HashMap());
        assert (f.equals((Object)Fqn.fromString((String)"/hello")));
    }

    public void testLeakageOfFqn() throws Throwable {
        ExecutorService e = Executors.newFixedThreadPool(1);
        final CopyOnWriteArrayList throwables = new CopyOnWriteArrayList();
        RegionManager rm = new RegionManager();
        final CacheMarshaller200 cm200 = new CacheMarshaller200(rm, false, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        final Fqn region = Fqn.fromString((String)"/hello");
        Region r = rm.getRegion(region, true);
        r.registerContextClassLoader(this.getClass().getClassLoader());
        cm200.objectToObjectStream((Object)MethodCallFactory.create((Method)MethodDeclarations.clusteredGetMethod, (Object[])new Object[]{null, null}), oos, region);
        oos.close();
        final byte[] stream = baos.toByteArray();
        for (int i = 0; i < 100; ++i) {
            if (i % 3 == 0) {
                e.execute(new Runnable(){

                    public void run() {
                        try {
                            cm200.objectFromObjectStream(new ObjectInputStream(new ByteArrayInputStream(stream)));
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ObjectOutputStream outStream = new ObjectOutputStream(out);
                            cm200.objectToObjectStream((Object)"A result", outStream);
                            outStream.close();
                            out.close();
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
                            assert (in.readByte() == 2) : "The stream should start with an Fqn";
                            in.readShort();
                            Fqn f = cm200.unmarshallFqn(in, new HashMap());
                            assert (region.equals((Object)f)) : "Should use the same region for the response as was used for the request!";
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                    }
                });
                continue;
            }
            if (i % 3 == 1) {
                e.execute(new Runnable(){

                    public void run() {
                        try {
                            cm200.objectFromObjectStream(new ObjectInputStream(new ByteArrayInputStream(stream)));
                            cm200.objectToObjectStream(null, new ObjectOutputStream(new ByteArrayOutputStream()));
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                    }
                });
                continue;
            }
            if (i % 3 != 2) continue;
            e.execute(new Runnable(){

                public void run() {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        cm200.objectToObjectStream((Object)true, outStream);
                        outStream.close();
                        out.close();
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
                        byte magic = in.readByte();
                        assert (magic != 2) : "The stream should NOT start with an Fqn!";
                        assert (magic == 99) : "Should start with a NULL";
                        assert (in.readByte() == 8) : "Should have a boolean magic number before the boolean value";
                        assert (in.readBoolean()) : "The boolean written to the stream should be true";
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                }
            });
        }
        e.shutdown();
        e.awaitTermination(60L, TimeUnit.SECONDS);
        for (Throwable t : throwables) {
            t.printStackTrace();
        }
        assert (throwables.size() == 0) : "Should not have caught any exceptions!";
    }
}

