/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import javax.transaction.Transaction;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ChildMapLazyLoadingTest {
    private CacheSPI<Object, Object> cache;
    private Fqn parent = Fqn.fromString((String)"/parent");
    private Fqn child = Fqn.fromString((String)"/parent/child");

    @BeforeMethod
    public void setUp() {
        this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.child, (Object)"k", (Object)"v");
    }

    @AfterMethod
    public void tearDown() {
        if (this.cache != null) {
            try {
                this.cache.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache.stop();
        }
    }

    public void testLazyLoadingOnCacheGet() throws Exception {
        this.cache.getTransactionManager().begin();
        assert (this.cache.get(this.parent, (Object)"k").equals("v")) : "Should retrieve value";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnCachePut() throws Exception {
        this.cache.getTransactionManager().begin();
        this.cache.put(this.parent, (Object)"k2", (Object)"v2");
        assert (this.cache.get(this.parent, (Object)"k2").equals("v2")) : "Should retrieve value";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnCachePutData() throws Exception {
        this.cache.getTransactionManager().begin();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("k2", "v2");
        this.cache.put(this.parent, data);
        assert (this.cache.get(this.parent, (Object)"k2").equals("v2")) : "Should retrieve value";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnCacheRemove() throws Exception {
        this.cache.getTransactionManager().begin();
        this.cache.remove(this.parent, (Object)"k");
        assert (this.cache.get(this.parent, (Object)"k") == null) : "Data should be removed";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnCacheRemoveNode() throws Exception {
        this.cache.getTransactionManager().begin();
        this.cache.removeNode(this.parent);
        assert (!this.cache.getRoot().hasChild(this.parent)) : "Node should be removed";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnCacheMove() throws Exception {
        Fqn newparentToMoveTo = Fqn.fromString((String)"/newparent");
        Fqn newparent = Fqn.fromString((String)"/newparent/parent");
        Fqn newchild = Fqn.fromString((String)"/newparent/parent/child");
        this.cache.getTransactionManager().begin();
        this.cache.move(this.parent, newparentToMoveTo);
        assert (!this.cache.getRoot().hasChild(this.parent)) : "Node should be removed";
        assert (!this.cache.getRoot().hasChild(this.child)) : "Node should be removed";
        assert (this.cache.getRoot().hasChild(newparent)) : "Node should have moved";
        assert (this.cache.getRoot().hasChild(newchild)) : "Node should have moved";
        assert (this.cache.get(newparent, (Object)"k").equals("v")) : "Data should have moved too";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (n.isChildrenLoaded()) : "Should have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeGet() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        assert (node.getData().size() == 1) : "Node should have data";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeRemove() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        node.clearData();
        assert (node.getData().size() == 0) : "Node should have removed data";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodePut() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        node.put((Object)"k2", (Object)"v2");
        assert (node.getData().size() == 2) : "Node should have added data";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeGetChildrenNames() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        assert (node.getChildrenNames().size() == 1) : "Node should have 1 child";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (n.isChildrenLoaded()) : "Should have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeGetChildren() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        assert (node.getChildren().size() == 1) : "Node should have 1 child";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (n.isChildrenLoaded()) : "Should have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeAddChild() throws Exception {
        Fqn newChild = Fqn.fromString((String)"/newchild");
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        node.addChild(newChild);
        assert (node.hasChild(newChild)) : "Node should have added child";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    public void testLazyLoadingOnNodeRemoveChild() throws Exception {
        this.cache.getTransactionManager().begin();
        Node node = this.cache.getRoot().getChild(this.parent);
        node.removeChild(this.child.getLastElement());
        assert (!node.hasChild(this.child.getLastElement())) : "Node should have removed child";
        WorkspaceNode n = this.getWorkspaceNode(this.parent);
        assert (!n.isChildrenLoaded()) : "Should not have loaded children";
        this.cache.getTransactionManager().commit();
    }

    private WorkspaceNode getWorkspaceNode(Fqn fqn) throws Exception {
        CacheImpl ci = (CacheImpl)this.cache;
        Transaction tx = ci.getTransactionManager().getTransaction();
        GlobalTransaction gtx = ci.getTransactionTable().get(tx);
        OptimisticTransactionEntry te = (OptimisticTransactionEntry)ci.getTransactionTable().get(gtx);
        TransactionWorkspace tw = te.getTransactionWorkSpace();
        return tw.getNode(fqn);
    }
}

