/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.ArrayList;
import org.jboss.cache.Fqn;
import org.jboss.cache.FqnComparator;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ComparatorTest {
    FqnComparator comp = new FqnComparator();

    public void testSingleCompare() {
        Fqn fqn2;
        Fqn fqn1 = Fqn.fromString((String)"one");
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2 = Fqn.fromString((String)"two")) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
    }

    public void testNullCompare() {
        Fqn fqn1 = new Fqn(new ArrayList());
        Fqn fqn2 = new Fqn(new ArrayList());
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
    }

    public void testOneNullCompare() {
        Fqn fqn1 = new Fqn(new ArrayList());
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("one");
        Fqn fqn2 = new Fqn(temp);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
    }

    public void testNotComparableCompare() {
        Fqn fqn1 = new Fqn(new ArrayList());
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("one");
        Fqn fqn2 = new Fqn(temp);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
    }

    public void testMultiChildCompare() {
        Fqn fqn2;
        Fqn fqn1 = Fqn.fromString((String)"/one/two");
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2 = Fqn.fromString((String)"/one/two/three")) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
    }

    public void testMultiNotChildCompare() {
        Fqn fqn2;
        Fqn fqn1 = Fqn.fromString((String)"/one/two");
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2 = Fqn.fromString((String)"/three/four")) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
    }

    public void testPartialMultiNotChildCompare() {
        Fqn fqn2;
        Fqn fqn1 = Fqn.fromString((String)"/one/two");
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2 = Fqn.fromString((String)"/three")) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
    }

    public void testEqualsMultidCompare() {
        Fqn fqn2;
        Fqn fqn1 = Fqn.fromString((String)"/one/two");
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2 = Fqn.fromString((String)"/one/two")) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
    }

    public void testStringIntMultidCompare() {
        Fqn fqn1 = Fqn.fromString((String)"/one/two");
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(1234);
        Fqn fqn2 = new Fqn(temp);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn2) > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn1) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn2, fqn2) == 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.comp.compare(fqn1, fqn1) == 0 ? 1 : 0) != 0);
    }

    public void testOrdinaryObjectCompare() {
        Fqn fqn1 = new Fqn(new Object[]{new XYZ(), new ABC()});
        Fqn fqn2 = new Fqn(new Object[]{"XYZ", "ABC"});
        Fqn fqn3 = new Fqn(new Object[]{"XYZ", new ABC()});
        Fqn fqn4 = new Fqn(new Object[]{"XYZ", new XYZ()});
        AssertJUnit.assertEquals((int)0, (int)this.comp.compare(fqn1, fqn2));
        AssertJUnit.assertEquals((int)0, (int)this.comp.compare(fqn1, fqn3));
        AssertJUnit.assertEquals((int)0, (int)this.comp.compare(fqn2, fqn3));
        AssertJUnit.assertEquals((boolean)true, (this.comp.compare(fqn1, fqn4) < 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((boolean)true, (this.comp.compare(fqn4, fqn1) > 0 ? 1 : 0) != 0);
    }

    private static class ABC {
        private ABC() {
        }

        public String toString() {
            return "ABC";
        }
    }

    private static class XYZ {
        private XYZ() {
        }

        public String toString() {
            return "XYZ";
        }
    }
}

