/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;

public class OpLockingInterceptorTest
extends AbstractOptimisticTestCase {
    public void testTransactionPrepareMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticLockingInterceptor lockingInterceptor = new OptimisticLockingInterceptor();
        lockingInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        lockingInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)lockingInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
        }
        catch (Throwable t) {
            // empty catch block
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getLocks().size());
        for (NodeLock lock : entry.getLocks()) {
            AssertJUnit.assertTrue((boolean)lock.isWriteLocked());
            AssertJUnit.assertEquals((Object)gtx, (Object)lock.getWriterOwner());
        }
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        mgr.commit();
        cache.stop();
    }

    public void testTransactionCommitMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticLockingInterceptor lockingInterceptor = new OptimisticLockingInterceptor();
        lockingInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        lockingInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)lockingInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
        }
        catch (Throwable t) {
            // empty catch block
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getLocks().size());
        for (NodeLock lock : entry.getLocks()) {
            AssertJUnit.assertTrue((boolean)lock.isWriteLocked());
            AssertJUnit.assertEquals((Object)gtx, (Object)lock.getWriterOwner());
        }
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)MethodDeclarations.optimisticPrepareMethod, (Object)dummy.getCalled());
        MethodCall commitMethod = MethodCallFactory.create((Method)MethodDeclarations.commitMethod, (Object[])new Object[]{gtx});
        try {
            cache._replicate(commitMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)3, (int)entry.getLocks().size());
        for (NodeLock lock : entry.getLocks()) {
            AssertJUnit.assertEquals((boolean)false, (boolean)lock.isLocked());
        }
        int i = 0;
        Iterator it = workspace.getNodes().values().iterator();
        while (it.hasNext()) {
            NodeSPI node = ((WorkspaceNode)it.next()).getNode();
            AssertJUnit.assertEquals((Object)node.getLock(), entry.getLocks().get(i));
            ++i;
        }
        AssertJUnit.assertEquals((Object)MethodDeclarations.commitMethod, (Object)dummy.getCalled());
        mgr.commit();
        cache.stop();
    }

    public void testTransactionRollbackMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticLockingInterceptor lockingInterceptor = new OptimisticLockingInterceptor();
        lockingInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        lockingInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)lockingInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
        }
        catch (Throwable t) {
            // empty catch block
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getLocks().size());
        for (NodeLock lock : entry.getLocks()) {
            AssertJUnit.assertTrue((boolean)lock.isWriteLocked());
            AssertJUnit.assertEquals((Object)gtx, (Object)lock.getWriterOwner());
        }
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)MethodDeclarations.optimisticPrepareMethod, (Object)dummy.getCalled());
        MethodCall rollbackMethod = MethodCallFactory.create((Method)MethodDeclarations.rollbackMethod, (Object[])new Object[]{gtx});
        try {
            cache._replicate(rollbackMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)3, (int)entry.getLocks().size());
        for (NodeLock lock : entry.getLocks()) {
            AssertJUnit.assertEquals((boolean)false, (boolean)lock.isLocked());
        }
        int i = 0;
        Iterator it = workspace.getNodes().values().iterator();
        while (it.hasNext()) {
            NodeSPI node = ((WorkspaceNode)it.next()).getNode();
            AssertJUnit.assertEquals((Object)node.getLock(), entry.getLocks().get(i));
            ++i;
        }
        AssertJUnit.assertEquals((Object)MethodDeclarations.rollbackMethod, (Object)dummy.getCalled());
        mgr.commit();
        cache.stop();
    }
}

