/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import junit.framework.Assert;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticWithPassivationTest
extends AbstractOptimisticTestCase {
    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        String xml = "            <config>\n                \n                <passivation>true</passivation>\n                <preload></preload>\n\n                <cacheloader>\n                    <class>org.jboss.cache.loader.DummyInMemoryCacheLoader</class>\n                    <async>false</async>\n                    <fetchPersistentState>false</fetchPersistentState>\n                    <ignoreModifications>false</ignoreModifications>\n                </cacheloader>\n                \n            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    private CacheImpl<Object, Object> createLocalCache() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheUnstarted(false);
        cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        cache.create();
        cache.start();
        return cache;
    }

    public void testPassivationLocal() throws Exception {
        CacheImpl<Object, Object> cache = this.createLocalCache();
        CacheLoader loader = cache.getCacheLoader();
        cache.remove(this.fqn);
        loader.remove(this.fqn);
        Assert.assertNull((Object)loader.get(this.fqn));
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        mgr.commit();
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        Assert.assertNull((Object)loader.get(this.fqn));
        mgr.begin();
        cache.evict(this.fqn);
        mgr.commit();
        mgr.begin();
        Assert.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        Assert.assertNull((Object)loader.get(this.fqn));
        mgr.commit();
        mgr.begin();
        cache.remove(this.fqn);
        loader.remove(this.fqn);
        mgr.commit();
    }
}

