/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class RemoveBeforeCreateTest
extends AbstractOptimisticTestCase {
    CacheImpl[] c = null;
    TransactionManager t;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.c = new CacheImpl[2];
        this.c[0] = this.createReplicatedCache(Configuration.CacheMode.REPL_ASYNC);
        this.c[1] = this.createReplicatedCache(Configuration.CacheMode.REPL_ASYNC);
        TestingUtil.blockUntilViewsReceived(this.c, 20000L);
        this.t = this.c[0].getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.c != null) {
            this.destroyCache((Cache<Object, Object>)this.c[0]);
            this.destroyCache((Cache<Object, Object>)this.c[1]);
            this.c = null;
        }
    }

    public void testControl() throws Exception {
        this.t.begin();
        this.c[0].put("/control", (Object)"key", (Object)"value");
        this.t.commit();
        TestingUtil.sleepThread(200L);
        AssertJUnit.assertEquals((Object)"value", (Object)this.c[0].get("/control", (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.c[1].get("/control", (Object)"key"));
        DefaultDataVersion v1 = (DefaultDataVersion)((NodeSPI)this.c[0].get("/control")).getVersion();
        AssertJUnit.assertEquals((long)1L, (long)v1.getRawVersion());
        DefaultDataVersion v2 = (DefaultDataVersion)((NodeSPI)this.c[1].get("/control")).getVersion();
        AssertJUnit.assertEquals((long)1L, (long)v2.getRawVersion());
    }

    public void testRemoveBeforePut() throws Exception {
        Fqn f = Fqn.fromString((String)"/test");
        AssertJUnit.assertNull((Object)this.c[0].get(f));
        AssertJUnit.assertNull((Object)this.c[1].get(f));
        this.t.begin();
        this.c[0].remove(f);
        this.t.commit();
        TestingUtil.sleepThread(200L);
        AssertJUnit.assertNull((Object)this.c[0].get(f));
        AssertJUnit.assertNull((Object)this.c[1].get(f));
    }
}

