/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.transaction.Transaction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;

public class ValidatorInterceptorTest
extends AbstractOptimisticTestCase {
    public void testTransactionvalidateMethod() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        OptimisticValidatorInterceptor validateInterceptor = new OptimisticValidatorInterceptor();
        validateInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)validateInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
        }
        catch (Throwable t) {
            // empty catch block
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTransactionValidateFailureMethod() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        OptimisticValidatorInterceptor validateInterceptor = new OptimisticValidatorInterceptor();
        validateInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)validateInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        workspace.getNode(Fqn.fromString((String)"/one/two")).getNode().setVersion((DataVersion)new DefaultDataVersion(2L));
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTransactionValidateCommitMethod() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        OptimisticValidatorInterceptor validateInterceptor = new OptimisticValidatorInterceptor();
        validateInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)validateInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall commitMethod = MethodCallFactory.create((Method)MethodDeclarations.commitMethod, (Object[])new Object[]{gtx});
        try {
            cache._replicate(commitMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        NodeSPI node = workspace.getNode(Fqn.fromString((String)"/")).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)cache.exists(node.getFqn()));
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)cache.exists(node.getFqn()));
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTransactionValidateFailRemoteCommitMethod() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        OptimisticValidatorInterceptor validateInterceptor = new OptimisticValidatorInterceptor();
        validateInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)validateInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall commitMethod = MethodCallFactory.create((Method)MethodDeclarations.commitMethod, (Object[])new Object[]{gtx});
        try {
            cache._replicate(commitMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        NodeSPI node = workspace.getNode(Fqn.fromString((String)"/")).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)cache.exists(node.getFqn()));
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)cache.exists(node.getFqn()));
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTransactionValidateRollbackMethod() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        OptimisticValidatorInterceptor validateInterceptor = new OptimisticValidatorInterceptor();
        validateInterceptor.setCache(cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)validateInterceptor);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{gtx, entry.getModifications(), gtx.getAddress(), Boolean.FALSE});
        try {
            cache._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall rollbackMethod = MethodCallFactory.create((Method)MethodDeclarations.rollbackMethod, (Object[])new Object[]{gtx});
        try {
            cache._replicate(rollbackMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }
}

