/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheModeLocalSimpleTest {
    private CacheImpl<Object, Object> cache1;
    private CacheImpl<Object, Object> cache2;
    private Option cacheModeLocal;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        Configuration c = new Configuration();
        this.cache1.setConfiguration(c);
        c.setCacheMode("REPL_SYNC");
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        c = new Configuration();
        this.cache2.setConfiguration(c);
        c.setCacheMode("REPL_SYNC");
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1.start();
        this.cache2.start();
        this.cacheModeLocal = new Option();
        this.cacheModeLocal.setCacheModeLocal(true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            this.cache2.stop();
            this.cache2 = null;
        }
    }

    public void testCacheModeLocalWithTx() throws Exception {
        TransactionManager mgr = this.cache1.getTransactionManager();
        mgr.begin();
        this.cache1.put(Fqn.fromString((String)"/replicate"), (Object)"k", (Object)"v");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(Fqn.fromString((String)"/not-replicate"), (Object)"k", (Object)"v");
        mgr.commit();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache1.get("/replicate", (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache1.get("/not-replicate", (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache2.get("/replicate", (Object)"k"));
        AssertJUnit.assertNull((Object)this.cache2.get("/not-replicate", (Object)"k"));
    }
}

