/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.options.TestVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ExplicitVersionsTest {
    private CacheImpl<String, String> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private String key = "key";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache != null) {
            this.tearDown();
        }
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testSimplePut() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        Assert.assertEquals((String)"value", (String)((String)this.cache.get(this.fqn, (Object)this.key)));
        NodeSPI node = (NodeSPI)this.cache.get(this.fqn);
        DataVersion versionFromCache = node.getVersion();
        Assert.assertEquals(TestVersion.class, versionFromCache.getClass());
        Assert.assertEquals((String)"99", (String)((TestVersion)versionFromCache).getInternalVersion());
    }

    public void testFailingPut() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        version = new TestVersion("25");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
        try {
            mgr.commit();
            Assert.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"expected to fail", (boolean)true);
        }
    }

    public void testIncompatibleVersionTypes() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion(777L));
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
        try {
            mgr.commit();
            Assert.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"expected to fail", (boolean)true);
        }
    }

    public void testExplicitVersionOnLeaf() throws Exception {
        this.cache.put("/org/domain/Entity", null);
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)((NodeSPI)this.cache.get("/org/domain/Entity")).getVersion()).getRawVersion());
        TestVersion v = new TestVersion("Arse");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)v);
        this.cache.put(Fqn.fromString((String)"/org/domain/Entity/EntityInstance#1"), (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)((NodeSPI)this.cache.get("/org/domain/Entity")).getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)((NodeSPI)this.cache.get("/org/domain/Entity/EntityInstance#1")).getVersion());
    }

    public void testExplicitVersionOnLeafImplicitParentCreation() throws Exception {
        TestVersion v = new TestVersion("Arse");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)v);
        this.cache.put(Fqn.fromString((String)"/org/domain/Entity/EntityInstance#1"), (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)((NodeSPI)this.cache.get("/org/domain/Entity")).getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)((NodeSPI)this.cache.get("/org/domain/Entity/EntityInstance#1")).getVersion());
    }

    public void testExplicitVersionsOnParents() {
        NodeSPI root = this.cache.getRoot();
        TestVersion lev2V = new TestVersion("Lev2-v");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)lev2V);
        root.addChild(Fqn.fromString((String)"LEV2"));
        NodeSPI lev2 = (NodeSPI)root.getChild(Fqn.fromString((String)"LEV2"));
        AssertJUnit.assertNotNull((Object)lev2);
        AssertJUnit.assertEquals((Object)lev2V, (Object)lev2.getVersion());
        TestVersion lev3V = new TestVersion("Lev3-v");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)lev3V);
        lev2.addChild(Fqn.fromString((String)"LEV3"));
        NodeSPI lev3 = (NodeSPI)lev2.getChild(Fqn.fromString((String)"LEV3"));
        AssertJUnit.assertNotNull((Object)lev3);
        AssertJUnit.assertEquals((Object)lev3V, (Object)lev3.getVersion());
        TestVersion lev4V = new TestVersion("Lev4-v");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)lev4V);
        lev3.addChild(Fqn.fromString((String)"LEV4"));
        NodeSPI lev4 = (NodeSPI)lev3.getChild(Fqn.fromString((String)"LEV4"));
        AssertJUnit.assertNotNull((Object)lev4);
        AssertJUnit.assertEquals((Object)lev4V, (Object)lev4.getVersion());
    }

    public void testExplicitVersionOnParentAndChild() throws Exception {
        TestVersion vParent = new TestVersion("Parent-Version");
        this.cache.getTransactionManager().begin();
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)vParent);
        this.cache.put(Fqn.fromString((String)"/parent"), (Object)"k", (Object)"v");
        this.cache.getTransactionManager().commit();
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)((NodeSPI)this.cache.get("/")).getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)((NodeSPI)this.cache.get("/parent")).getVersion());
        TestVersion vChild = new TestVersion("Child-Version");
        this.cache.getTransactionManager().begin();
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)vChild);
        this.cache.put(Fqn.fromString((String)"/parent/child"), (Object)"k", (Object)"v");
        this.cache.getTransactionManager().commit();
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)((NodeSPI)this.cache.get("/")).getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)((NodeSPI)this.cache.get("/parent")).getVersion());
        AssertJUnit.assertEquals((Object)vChild, (Object)((NodeSPI)this.cache.get("/parent/child")).getVersion());
    }
}

