/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.io.File;
import java.io.FileFilter;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.passivation.PassivationTestsBase;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class PassivationToBdbjeCacheLoaderTest
extends PassivationTestsBase {
    private String tmp_location = System.getProperty("java.io.tmpdir", "c:\\tmp");
    private File dir = new File(this.tmp_location);

    public PassivationToBdbjeCacheLoaderTest() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
    }

    protected void configureCache() throws Exception {
        class MyFilter
        implements FileFilter {
            MyFilter() {
            }

            public boolean accept(File file) {
                return file.getName().endsWith(".jdb");
            }
        }
        File[] files = this.dir.listFiles(new MyFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile() || file.delete()) continue;
                System.err.println("Unable to delete: " + file);
            }
        }
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(this.tmp_location));
    }

    protected CacheLoaderConfig getCacheLoaderConfig(String loc) throws Exception {
        String xml = "            <config>\n                \n                <passivation>true</passivation>\n                <preload></preload>\n\n                <cacheloader>\n                    <class>org.jboss.cache.loader.bdbje.BdbjeCacheLoader</class>\n                    <properties>\n                    </properties>\n                    <async>false</async>\n                    <fetchPersistentState>false</fetchPersistentState>\n                    <ignoreModifications>false</ignoreModifications>\n                </cacheloader>\n                \n            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }
}

