/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class StateTransferTestBase
extends AbstractCacheLoaderTestBase {
    protected static final int SUBTREE_SIZE = 10;
    public static final Fqn<String> A = Fqn.fromString((String)"/a");
    public static final Fqn<String> B = Fqn.fromString((String)"/b");
    public static final Fqn<String> C = Fqn.fromString((String)"/c");
    protected static final String ADDRESS_CLASSNAME = "org.jboss.cache.marshall.data.Address";
    protected static final String PERSON_CLASSNAME = "org.jboss.cache.marshall.data.Person";
    public static final Fqn<String> A_B = Fqn.fromString((String)"/a/b");
    public static final Fqn<String> A_C = Fqn.fromString((String)"/a/c");
    public static final Fqn<String> A_D = Fqn.fromString((String)"/a/d");
    public static final String JOE = "JOE";
    public static final String BOB = "BOB";
    public static final String JANE = "JANE";
    public static final Integer TWENTY = 20;
    public static final Integer FORTY = 40;
    protected Map<String, Cache> caches;
    private ClassLoader orig_TCL;

    protected abstract String getReplicationVersion();

    protected CacheSPI<Object, Object> createCache(String cacheID, boolean sync, boolean useMarshalling, boolean useCacheLoader) throws Exception {
        return this.createCache(cacheID, sync, useMarshalling, useCacheLoader, false, true);
    }

    protected CacheSPI<Object, Object> createCache(String cacheID, boolean sync, boolean useMarshalling, boolean useCacheLoader, boolean cacheLoaderAsync, boolean startCache) throws Exception {
        if (useCacheLoader) {
            return this.createCache(cacheID, sync, useMarshalling, "org.jboss.cache.loader.FileCacheLoader", cacheLoaderAsync, startCache);
        }
        return this.createCache(cacheID, sync, useMarshalling, null, cacheLoaderAsync, startCache);
    }

    protected CacheSPI<Object, Object> createCache(String cacheID, boolean sync, boolean useMarshalling, String cacheLoaderClass, boolean cacheLoaderAsync, boolean startCache) throws Exception {
        if (this.caches.get(cacheID) != null) {
            throw new IllegalStateException(cacheID + " already created");
        }
        Configuration.CacheMode mode = sync ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC;
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(mode);
        if (sync) {
            c.setSyncRollbackPhase(true);
            c.setSyncCommitPhase(true);
        }
        c.setClusterName("VersionedTestBase");
        c.setReplVersionString(this.getReplicationVersion());
        c.setStateRetrievalTimeout(60000L);
        if (useMarshalling) {
            c.setUseRegionBasedMarshalling(true);
            c.setInactiveOnStartup(true);
        }
        if (cacheLoaderClass != null && cacheLoaderClass.length() > 0) {
            this.configureCacheLoader(c, cacheLoaderClass, cacheID, useMarshalling, cacheLoaderAsync);
        }
        CacheSPI tree = (CacheSPI)DefaultCacheFactory.getInstance().createCache(c, false);
        this.configureMultiplexer((Cache)tree);
        this.caches.put(cacheID, (Cache)tree);
        if (startCache) {
            tree.create();
            tree.start();
        }
        return tree;
    }

    protected void createAndActivateRegion(CacheSPI<Object, Object> c, Fqn f) {
        Region r = c.getRegion(f, true);
        r.registerContextClassLoader(this.getClass().getClassLoader());
        r.activate();
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    protected void startCache(Cache cache) throws Exception {
        cache.create();
        cache.start();
        this.validateMultiplexer(cache);
    }

    protected void configureCacheLoader(Configuration c, String cacheID, boolean useExtended, boolean async) throws Exception {
        this.configureCacheLoader(c, "org.jboss.cache.loader.FileCacheLoader", cacheID, useExtended, async);
    }

    protected void configureCacheLoader(Configuration c, String cacheloaderClass, String cacheID, boolean useExtended, boolean async) throws Exception {
        if (cacheloaderClass != null) {
            if (cacheloaderClass.equals("org.jboss.cache.loader.JDBCCacheLoader")) {
                Properties prop = new Properties();
                try {
                    prop.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
                }
                catch (Exception e) {
                    System.out.println("Error loading jdbc properties ");
                }
                String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" + "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" + "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" + "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" + "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat");
                c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
            } else {
                String tmp_location = this.getTempLocation(cacheID);
                File file = new File(tmp_location);
                this.cleanFile(file);
                file.mkdir();
                tmp_location = this.escapeWindowsPath(tmp_location);
                String props = "location = " + tmp_location + "\n";
                c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", cacheloaderClass, props, async, true, false));
            }
        }
    }

    protected void initialStateTferWithLoaderTest(String cacheLoaderClass1, String cacheLoaderClass2, boolean asyncLoader) throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, false, cacheLoaderClass1, false, true);
        cache1.put(A_B, (Object)"name", (Object)JOE);
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)BOB);
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, false, cacheLoaderClass2, asyncLoader, false);
        cache2.start();
        TestingUtil.blockUntilViewsReceived((Cache[])new CacheSPI[]{cache1, cache2}, 60000L);
        if (asyncLoader) {
            TestingUtil.sleepThread(100L);
        }
        CacheLoader loader = cache2.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((String)"Incorrect loader name for /a/b", (Object)JOE, loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect loader age for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect loader name for /a/c", (Object)BOB, loader.get(A_C).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect loader age for /a/c", (Object)FORTY, loader.get(A_C).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)JOE, (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)BOB, (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
    }

    protected String getTempLocation(String cacheID) {
        String tmp_location = System.getProperty("java.io.tmpdir", "c:\\tmp");
        File file = new File(tmp_location);
        file = new File(file, cacheID);
        return file.getAbsolutePath();
    }

    protected String escapeWindowsPath(String path) {
        if ('/' == File.separatorChar) {
            return path;
        }
        char[] chars = path.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char aChar : chars) {
            if (aChar == '\\') {
                sb.append('\\');
            }
            sb.append(aChar);
        }
        return sb.toString();
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.caches = new HashMap<String, Cache>();
        this.orig_TCL = Thread.currentThread().getContextClassLoader();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("*** in tearDown()");
        Thread.currentThread().setContextClassLoader(this.orig_TCL);
        for (String cacheID : this.caches.keySet()) {
            try {
                this.stopCache(this.caches.get(cacheID));
                TestingUtil.sleepThread(1500L);
                File file = new File(this.getTempLocation(cacheID));
                this.cleanFile(file);
            }
            catch (Exception exception) {}
        }
    }

    protected void stopCache(Cache cache) {
        if (cache != null) {
            try {
                cache.stop();
                cache.destroy();
            }
            catch (Exception e) {
                System.out.println("Exception stopping cache " + e.getMessage());
                e.printStackTrace(System.out);
            }
        }
    }

    protected void cleanFile(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                this.cleanFile(child);
            }
        }
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            file.deleteOnExit();
        }
    }

    protected ClassLoader getClassLoader() throws Exception {
        String[] includesClasses = new String[]{"org.jboss.cache.marshall.Person", "org.jboss.cache.marshall.Address"};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    protected ClassLoader getNotFoundClassLoader() throws Exception {
        String[] notFoundClasses = new String[]{"org.jboss.cache.marshall.Person", "org.jboss.cache.marshall.Address"};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(null, null, notFoundClasses, cl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CacheUser
    implements Runnable {
        protected Semaphore semaphore;
        protected CacheSPI<Object, Object> cache;
        protected String name;
        protected Exception exception;
        protected Thread thread;

        CacheUser() {
        }

        CacheUser(Semaphore semaphore, String name, boolean sync, boolean activateRoot) throws Exception {
            this.cache = StateTransferTestBase.this.createCache(name, sync, true, false);
            this.semaphore = semaphore;
            this.name = name;
            if (activateRoot) {
                this.cache.getRegion(Fqn.ROOT, true).activate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60L, TimeUnit.SECONDS);
                if (!acquired) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                this.useCache();
            }
            catch (Exception e) {
                System.out.println(this.name + ": " + e.getLocalizedMessage());
                e.printStackTrace(System.out);
                this.exception = e;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        }

        abstract void useCache() throws Exception;

        public Exception getException() {
            return this.exception;
        }

        public CacheSPI<Object, Object> getCacheSPI() {
            return this.cache;
        }

        public String getName() {
            return this.name;
        }

        public void start() {
            this.thread = new Thread((Runnable)this, this.name);
            this.thread.start();
        }

        public void cleanup() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
        }
    }
}

