/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, enabled=false)
public class ConcurrentBankTest {
    private CacheImpl<Object, Integer> cache;
    private static Log logger_ = LogFactory.getLog(ConcurrentBankTest.class);
    private final String NODE = "/cachetest";
    private final int ROLLBACK_CHANCE = 100;
    private static String[] customer = new String[]{"cu1", "cu2", "cu3"};
    private static final int BOOKINGS = 1000;
    private static boolean _testFailedinThread = false;

    private void failMain() {
        _testFailedinThread = true;
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.setConfiguration(new XmlConfigurationParser().parseFile("META-INF/local-lru-eviction-service.xml"));
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
        TransactionSetup.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentBooking() {
        try {
            if (this.cache.get("/cachetest") == null) {
                this.cache.put("/cachetest", (Object)"cu1", (Object)1000);
                this.cache.put("/cachetest", (Object)"cu2", (Object)1000);
                this.cache.put("/cachetest", (Object)"cu3", (Object)1000);
            }
            Teller one = new Teller("one", this.cache);
            Teller two = new Teller("two", this.cache);
            one.start();
            TestingUtil.sleepThread(100L);
            two.start();
            one.join();
            two.join();
            ConcurrentBankTest.log("lock info:\n" + this.cache.printLockInfo() + _testFailedinThread);
            if (_testFailedinThread) {
                AssertJUnit.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.toString());
        }
    }

    private static void log(String msg) {
        logger_.info((Object)("-- [" + Thread.currentThread() + "]: " + msg));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Teller
    extends Thread {
        CacheImpl<Object, Integer> cache;

        public Teller(String str, CacheImpl<Object, Integer> cache) {
            super(str);
            this.cache = cache;
        }

        @Override
        public void run() {
            int count = customer.length;
            UserTransaction tx = null;
            try {
                tx = TransactionSetup.getUserTransaction();
                boolean again = false;
                int src = 0;
                int dst = 0;
                int amo = 0;
                for (int anz = 0; anz < 1000; ++anz) {
                    if (!again) {
                        src = (int)(Math.random() * (double)count);
                        dst = (int)(Math.random() * (double)(count - 1));
                        amo = 1 + (int)(Math.random() * 20.0);
                        if (dst >= src) {
                            ++dst;
                        }
                    }
                    tx.begin();
                    HashMap<Object, Integer> accounts = this.getAccounts();
                    tx.commit();
                    int sum = this.sumAccounts(accounts);
                    ConcurrentBankTest.log(anz + ": " + accounts + " Summe: " + sum);
                    if (sum != 3000) {
                        ConcurrentBankTest.this.failMain();
                        return;
                    }
                    AssertJUnit.assertEquals((String)"the sum of all accounts always has to be 3000", (int)3000, (int)sum);
                    try {
                        tx.begin();
                        this.deposit(customer[src], customer[dst], amo, tx);
                        tx.commit();
                        again = false;
                    }
                    catch (TimeoutException timeout_ex) {
                        System.out.println("transaction is rolled back, will try again (ex=" + ((Object)((Object)timeout_ex)).getClass() + ")");
                        tx.rollback();
                        again = true;
                    }
                    catch (Throwable e) {
                        System.out.println("transaction is rolled back, will try again (ex=" + e.getMessage() + ")");
                        tx.rollback();
                        again = true;
                    }
                    Teller.yield();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                AssertJUnit.fail((String)t.toString());
            }
        }

        public void deposit(String from, String to, int amount, UserTransaction tx) throws Exception {
            ConcurrentBankTest.log("deposit(" + from + ", " + to + ", " + amount + ") called.");
            int act = (Integer)this.cache.get("/cachetest", (Object)from);
            this.cache.put("/cachetest", (Object)from, (Object)(act - amount));
            ConcurrentBankTest.log("deposit(" + from + ", " + to + ", " + amount + ") debited.");
            if ((int)(Math.random() * 100.0) == 0) {
                ConcurrentBankTest.log("!!!manually set rollback (" + from + ", " + to + ", " + amount + ").");
                tx.setRollbackOnly();
                throw new Exception("Manually set rollback!");
            }
            act = (Integer)this.cache.get("/cachetest", (Object)to);
            this.cache.put("/cachetest", (Object)to, (Object)(act + amount));
            ConcurrentBankTest.log("deposit(" + from + ", " + to + ", " + amount + ") finished.");
        }

        public HashMap<Object, Integer> getAccounts() throws CacheException {
            ConcurrentBankTest.log("getAccounts() called.");
            HashMap<Object, Integer> result = new HashMap<Object, Integer>();
            Set set = this.cache.getKeys("/cachetest");
            for (Object name : set) {
                result.put(name, (Integer)this.cache.get("/cachetest", name));
            }
            return result;
        }

        protected int sumAccounts(HashMap<Object, Integer> map) {
            Iterator<Integer> iter = map.values().iterator();
            int result = 0;
            while (iter.hasNext()) {
                result += iter.next().intValue();
            }
            return result;
        }
    }
}

