/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class IsolationLevelReadCommittedTest {
    private Cache<String, String> cache = null;
    private final Fqn FQN = Fqn.fromString((String)"/a/b/c");
    private final Fqn PARENT_FQN = this.FQN.getParent();
    private final String KEY = "key";
    private final String VALUE = "value";
    private volatile boolean writerFailed;
    private volatile boolean readerFailed;
    private volatile AssertionFailedError writerError;
    private volatile AssertionFailedError readerError;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.writerFailed = false;
        this.readerFailed = false;
        this.writerError = null;
        this.readerError = null;
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        config.setLockAcquisitionTimeout(1000L);
        config.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = instance.createCache(config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache = null;
    }

    public void testReadCommitted() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerCanWrite = new CountDownLatch(1);
        final CountDownLatch writerCanRollback = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread readerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TransactionManager tm = null;
                try {
                    tm = IsolationLevelReadCommittedTest.this.startTransaction();
                    AssertJUnit.assertEquals((String)"Could not read node with expected value!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                    writerCanWrite.countDown();
                    readerCanRead.await();
                    try {
                        AssertJUnit.assertEquals((String)"thread w/ read lock can see subsequent uncommitted changes!!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                    }
                    catch (TimeoutException good) {
                        // empty catch block
                    }
                    writerCanRollback.countDown();
                    AssertJUnit.assertEquals((String)"Could not read node with expected value!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                }
                catch (AssertionFailedError e) {
                    IsolationLevelReadCommittedTest.this.readerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelReadCommittedTest.this.readerFailed = true;
                }
                finally {
                    System.out.println("reader thread exits");
                    if (tm != null) {
                        try {
                            tm.commit();
                        }
                        catch (Exception e) {}
                    }
                    writerCanWrite.countDown();
                    writerCanRollback.countDown();
                    readerDone.countDown();
                }
            }
        }, "READER");
        readerThread.start();
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    writerCanWrite.await(3L, TimeUnit.SECONDS);
                    TransactionManager tm = IsolationLevelReadCommittedTest.this.startTransaction();
                    IsolationLevelReadCommittedTest.this.cache.put(IsolationLevelReadCommittedTest.this.FQN, (Object)"key", (Object)"this-shouldnt-be-visible");
                    readerCanRead.countDown();
                    writerCanWrite.await(3L, TimeUnit.SECONDS);
                    System.out.println("rolling back");
                    tm.rollback();
                }
                catch (AssertionFailedError e) {
                    IsolationLevelReadCommittedTest.this.writerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelReadCommittedTest.this.writerFailed = true;
                }
                finally {
                    System.out.println("writer thread exits");
                    readerCanRead.countDown();
                    writerDone.countDown();
                }
            }
        }, "WRITER");
        writerThread.start();
        readerDone.await();
        writerDone.await();
        if (this.readerError != null) {
            throw this.readerError;
        }
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.readerFailed) {
            AssertJUnit.fail((String)"The reader thread exited incorrectly. Watch the log for previous stack traces");
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeRemoved() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TransactionManager mgr = IsolationLevelReadCommittedTest.this.startTransaction();
                    IsolationLevelReadCommittedTest.this.cache.removeNode(IsolationLevelReadCommittedTest.this.PARENT_FQN);
                    readerCanRead.countDown();
                    readerDone.await();
                    mgr.commit();
                }
                catch (AssertionFailedError e) {
                    IsolationLevelReadCommittedTest.this.writerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelReadCommittedTest.this.writerFailed = true;
                }
                finally {
                    System.out.println("writer thread exits");
                    readerCanRead.countDown();
                    writerDone.countDown();
                }
            }
        }, "WRITER");
        writerThread.start();
        try {
            readerCanRead.await();
            AssertJUnit.assertEquals((String)"2nd thread cannot see uncommitted changes", (String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        }
        catch (TimeoutException t) {
        }
        finally {
            System.out.println("reader thread exits");
            readerDone.countDown();
        }
        writerDone.await();
        AssertJUnit.assertNull((String)"Node was removed", (Object)((CacheImpl)this.cache).get(this.FQN));
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

