/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.concurrent.CountDownLatch;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class IsolationLevelRepeatableReadTest {
    private CacheImpl<String, String> cache = null;
    private final Fqn FQN = Fqn.fromString((String)"/a");
    private final String KEY = "key";
    private final String VALUE = "value";
    private volatile boolean writerFailed;
    private volatile AssertionFailedError writerError;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.writerFailed = false;
        this.writerError = null;
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode("LOCAL");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.getConfiguration().setLockAcquisitionTimeout(1000L);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeRemoved() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TransactionManager tm = IsolationLevelRepeatableReadTest.this.startTransaction();
                    IsolationLevelRepeatableReadTest.this.cache.remove(IsolationLevelRepeatableReadTest.this.FQN);
                    readerCanRead.countDown();
                    readerDone.await();
                    tm.commit();
                }
                catch (AssertionFailedError e) {
                    IsolationLevelRepeatableReadTest.this.writerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelRepeatableReadTest.this.writerFailed = true;
                }
                finally {
                    System.out.println("writer thread exits");
                    readerCanRead.countDown();
                    writerDone.countDown();
                }
            }
        }, "WRITER");
        writerThread.start();
        try {
            readerCanRead.await();
            AssertJUnit.assertEquals((String)"2nd thread cannot see uncommitted changes", (String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        }
        catch (TimeoutException t) {
        }
        finally {
            System.out.println("reader thread exits");
            readerDone.countDown();
        }
        writerDone.await();
        AssertJUnit.assertNull((String)"Node was not removed", (Object)this.cache.get(this.FQN));
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

