/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.ArrayList;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, enabled=false)
public class SimultaneousRollbackAndPutTest {
    private Cache cache;
    private TransactionManager tm;
    private Fqn A = Fqn.fromString((String)"/a");
    private Fqn B = Fqn.fromString((String)"/b");

    @BeforeTest(alwaysRun=true)
    protected void setUp() throws Exception {
        this.cache = DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.cache.put(this.A, (Object)"k", (Object)"v");
    }

    @AfterTest(alwaysRun=true)
    protected void tearDown() {
        this.cache.stop();
    }

    @AfterMethod(alwaysRun=true)
    protected void resetCache() {
        this.cache.removeNode(this.B);
        this.cache.getRoot().getChild(this.A).clearData();
        this.cache.put(this.A, (Object)"k", (Object)"v");
    }

    @Test(invocationCount=200, alwaysRun=false, enabled=false)
    public void testStaleLocks() throws Exception {
        this.tm.begin();
        final Transaction t = this.tm.getTransaction();
        final ArrayList exceptions = new ArrayList();
        this.cache.put(this.B, (Object)"k", (Object)"v");
        new Thread(){

            public void run() {
                try {
                    t.rollback();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }.start();
        this.cache.put(this.A, (Object)"k2", (Object)"v2");
        try {
            this.tm.commit();
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        assert (0 == ((CacheImpl)this.cache).getNumberOfLocksHeld());
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
    }
}

