/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.isolationlevels;

import java.util.Collection;
import java.util.HashSet;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public abstract class IsolationLevelTestBase {
    protected IsolationLevel isolationLevel;
    protected Cache<String, String> cache;
    protected TransactionManager transactionManager;
    protected Fqn<String> fqn = Fqn.fromString((String)"/a/b/c");
    protected Fqn<String> fqnChild1 = Fqn.fromString((String)"/a/b/c/child1");
    protected Fqn<String> fqnChild2 = Fqn.fromString((String)"/a/b/c/child2");
    protected String k = "key";
    protected String v = "value";
    protected Collection<IsolationLevel> allowedLevels;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        CacheFactory cf = DefaultCacheFactory.getInstance();
        this.cache = cf.createCache(false);
        this.cache.getConfiguration().setIsolationLevel(this.isolationLevel);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.getConfiguration().setLockAcquisitionTimeout(250L);
        this.cache.start();
        this.transactionManager = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.allowedLevels = new HashSet<IsolationLevel>();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.transactionManager != null) {
            try {
                this.transactionManager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cache.stop();
        this.cache.destroy();
        this.cache = null;
        this.allowedLevels = null;
    }

    public void testDirtyRead() throws Exception {
        Transaction t1;
        block3: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.transactionManager.begin();
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block3;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        this.transactionManager.rollback();
    }

    public void testDirtyReadWithNoData() throws Exception {
        Transaction t1;
        block5: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.allowedLevels.add(IsolationLevel.READ_COMMITTED);
            this.allowedLevels.add(IsolationLevel.REPEATABLE_READ);
            this.transactionManager.begin();
            AssertJUnit.assertNull((Object)this.cache.get(this.fqn, (Object)this.k));
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block5;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        if (this.allowedLevels.contains(this.isolationLevel)) {
            AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
        } else {
            AssertJUnit.assertNull((Object)this.cache.get(this.fqn, (Object)this.k));
        }
        this.transactionManager.rollback();
    }

    public void testTwoReads() throws Exception {
        Transaction t1;
        block3: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.allowedLevels.add(IsolationLevel.READ_COMMITTED);
            this.allowedLevels.add(IsolationLevel.REPEATABLE_READ);
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            this.transactionManager.begin();
            AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block3;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        this.transactionManager.rollback();
    }

    public void testTwoWrites() throws Exception {
        Transaction t1;
        block3: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            this.transactionManager.begin();
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block3;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        this.transactionManager.rollback();
    }

    public void testNonRepeatableRead() throws Exception {
        Transaction t1;
        block3: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.allowedLevels.add(IsolationLevel.READ_COMMITTED);
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            this.transactionManager.begin();
            AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block3;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
        this.transactionManager.rollback();
    }

    public void testNonRepeatableReadWithNoData() throws Exception {
        Transaction t1;
        block5: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.allowedLevels.add(IsolationLevel.READ_COMMITTED);
            this.allowedLevels.add(IsolationLevel.REPEATABLE_READ);
            this.transactionManager.begin();
            AssertJUnit.assertNull((Object)this.cache.get(this.fqn, (Object)this.k));
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block5;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        if (this.allowedLevels.contains(this.isolationLevel)) {
            AssertJUnit.assertEquals((String)this.v, (String)((String)this.cache.get(this.fqn, (Object)this.k)));
        } else {
            AssertJUnit.assertNull((Object)this.cache.get(this.fqn, (Object)this.k));
        }
        this.transactionManager.rollback();
    }

    public void testPhantomRead() throws Exception {
        Transaction t1;
        int numChildren;
        block3: {
            this.allowedLevels.add(IsolationLevel.NONE);
            this.allowedLevels.add(IsolationLevel.READ_UNCOMMITTED);
            this.allowedLevels.add(IsolationLevel.READ_COMMITTED);
            this.allowedLevels.add(IsolationLevel.REPEATABLE_READ);
            this.cache.put(this.fqn, (Object)this.k, (Object)this.v);
            this.cache.put(this.fqnChild1, (Object)this.k, (Object)this.v);
            this.transactionManager.begin();
            numChildren = this.cache.getRoot().getChild(this.fqn).getChildren().size();
            AssertJUnit.assertEquals((int)1, (int)numChildren);
            t1 = this.transactionManager.suspend();
            this.transactionManager.begin();
            try {
                this.cache.put(this.fqnChild2, (Object)this.k, (Object)this.v);
                this.transactionManager.commit();
                if (!this.allowedLevels.contains(this.isolationLevel)) {
                    AssertJUnit.fail((String)"Should have thrown an exception");
                }
            }
            catch (Exception e) {
                this.transactionManager.rollback();
                if (!this.allowedLevels.contains(this.isolationLevel)) break block3;
                throw e;
            }
        }
        this.transactionManager.resume(t1);
        numChildren = this.cache.getRoot().getChild(this.fqn).getChildren().size();
        AssertJUnit.assertEquals((int)(this.allowedLevels.contains(this.isolationLevel) ? 2 : 1), (int)numChildren);
        this.transactionManager.rollback();
    }
}

