/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class InstanceAdvisorDelegate
implements Serializable {
    private static final long serialVersionUID = -5421366346785427537L;
    protected transient WeakReference classAdvisor;
    InstanceAdvisor instanceAdvisor;
    protected transient WeakHashMap aspects;
    protected transient WeakHashMap joinpointAspects;
    protected SimpleMetaData metadata;

    public InstanceAdvisorDelegate(Advisor classAdvisor, InstanceAdvisor instanceAdvisor) {
        this.instanceAdvisor = instanceAdvisor;
        this.classAdvisor = new WeakReference<Advisor>(classAdvisor);
    }

    public Advisor getAdvisor() {
        if (this.classAdvisor != null) {
            return (Advisor)this.classAdvisor.get();
        }
        return null;
    }

    public void initialize() {
        this.initializeAspects();
        this.initializeJoinpointAspects();
    }

    private Advisor getClassAdvisor() {
        return this.getAdvisor();
    }

    private synchronized void initializeAspects() {
        Set defs;
        Advisor ia;
        Set instanceDefs;
        if (this.getClassAdvisor() == null) {
            return;
        }
        if (this.aspects != null) {
            return;
        }
        if (this.instanceAdvisor instanceof Advisor && (instanceDefs = (ia = (Advisor)((Object)this.instanceAdvisor)).getPerInstanceAspectDefinitions()).size() > 0) {
            this.aspects = new WeakHashMap();
            for (AspectDefinition def : instanceDefs) {
                ia.addPerInstanceAspect(def);
                Object aspect = def.getFactory().createPerInstance(this.getClassAdvisor(), this.instanceAdvisor);
                this.aspects.put(def, aspect);
            }
        }
        if ((defs = this.getClassAdvisor().getPerInstanceAspectDefinitions()).size() > 0) {
            if (this.aspects == null) {
                this.aspects = new WeakHashMap();
            }
            for (AspectDefinition def : defs) {
                Object aspect = def.getFactory().createPerInstance(this.getClassAdvisor(), this.instanceAdvisor);
                this.aspects.put(def, aspect);
            }
        }
    }

    private synchronized void initializeJoinpointAspects() {
        Map jpAspects;
        Advisor ia;
        Map instanceJpAspects;
        if (this.getClassAdvisor() == null) {
            return;
        }
        if (this.joinpointAspects != null) {
            return;
        }
        if (this.instanceAdvisor instanceof Advisor && (instanceJpAspects = (ia = (Advisor)((Object)this.instanceAdvisor)).getPerInstanceJoinpointAspectDefinitions()).size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            for (AspectDefinition def : instanceJpAspects.keySet()) {
                this.initJoinpointAspect(def, instanceJpAspects);
                Set joinpoints = (Set)instanceJpAspects.get(def);
                ia.addPerInstanceJoinpointAspect(joinpoints, def);
            }
        }
        if ((jpAspects = this.getClassAdvisor().getPerInstanceJoinpointAspectDefinitions()).size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            for (AspectDefinition def : jpAspects.keySet()) {
                this.initJoinpointAspect(def, jpAspects);
            }
        }
    }

    private void initJoinpointAspect(AspectDefinition def, Map jpAspects) {
        ConcurrentHashMap joins = new ConcurrentHashMap();
        this.joinpointAspects.put(def, joins);
        Set joinpoints = (Set)jpAspects.get(def);
        for (Object joinpoint : joinpoints) {
            joins.put(joinpoint, def.getFactory().createPerJoinpoint(this.getClassAdvisor(), this.instanceAdvisor, (Joinpoint)joinpoint));
        }
    }

    public Object getPerInstanceAspect(String def) {
        for (AspectDefinition d : this.aspects.keySet()) {
            if (!d.getName().equals(def)) continue;
            return this.aspects.get(d);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAspect(AspectDefinition def) {
        if (this.aspects == null) {
            this.initializeAspects();
            return this.aspects.get(def);
        }
        Object aspect = this.aspects.get(def);
        if (aspect == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                aspect = this.aspects.get(def);
                if (aspect != null) {
                    return aspect;
                }
                if (this.classAdvisor != null && this.getClassAdvisor() instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.getClassAdvisor();
                    cadvisor.getPerInstanceAspectDefinitions().add(def);
                    aspect = def.getFactory().createPerInstance(null, null);
                    WeakHashMap copy = new WeakHashMap(this.aspects);
                    copy.put(def, aspect);
                    this.aspects = copy;
                }
            }
        }
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        if (this.joinpointAspects == null) {
            this.initializeJoinpointAspects();
            return this.getJoinpointAspect(def, joinpoint);
        }
        Object aspect = this.getJoinpointAspect(def, joinpoint);
        if (aspect == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                aspect = this.getJoinpointAspect(def, joinpoint);
                if (aspect != null) {
                    return aspect;
                }
                if (this.classAdvisor != null && this.getClassAdvisor() instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.getClassAdvisor();
                    cadvisor.addPerInstanceJoinpointAspect(joinpoint, def);
                    aspect = def.getFactory().createPerJoinpoint(this.getClassAdvisor(), this.instanceAdvisor, joinpoint);
                    WeakHashMap copy = new WeakHashMap(this.joinpointAspects);
                    ConcurrentHashMap<Joinpoint, Object> map = (ConcurrentHashMap<Joinpoint, Object>)copy.get(def);
                    if (map == null) {
                        map = new ConcurrentHashMap<Joinpoint, Object>();
                    }
                    map.put(joinpoint, aspect);
                    this.joinpointAspects = copy;
                }
            }
        }
        return aspect;
    }

    private Object getJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        if (this.joinpointAspects == null) {
            return null;
        }
        Map map = (Map)this.joinpointAspects.get(def);
        Object aspect = map.get(joinpoint);
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                if (this.metadata == null) {
                    this.metadata = new SimpleMetaData();
                }
            }
        }
        return this.metadata;
    }
}

