/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.repository.basic;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.metadata.plugins.repository.AbstractMetaDataRepository;
import org.jboss.metadata.plugins.repository.visitor.ChildrenMetaDataRepositoryVisitor;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMetaDataRepository
extends AbstractMetaDataRepository
implements MutableMetaDataRepository {
    private Map<ScopeKey, MetaDataRetrieval> retrievals = new ConcurrentHashMap<ScopeKey, MetaDataRetrieval>();

    @Override
    public MetaDataRetrieval getMetaDataRetrieval(ScopeKey key) {
        return this.retrievals.get(key);
    }

    @Override
    public Set<ScopeKey> getChildren(ScopeKey key) {
        if (key == null) {
            return this.retrievals.keySet();
        }
        ChildrenMetaDataRepositoryVisitor visitor = new ChildrenMetaDataRepositoryVisitor(key);
        return this.matchScopes(visitor);
    }

    @Override
    public Set<ScopeKey> matchScopes(MetaDataRepositoryVisitor visitor) {
        HashSet<ScopeKey> result = new HashSet<ScopeKey>();
        for (ScopeKey repositoryKey : this.retrievals.keySet()) {
            if (!visitor.matchScope(this, repositoryKey)) continue;
            result.add(repositoryKey);
        }
        return result;
    }

    @Override
    public MetaDataRetrieval addMetaDataRetrieval(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        ScopeKey key = retrieval.getScope();
        key.freeze();
        return this.retrievals.put(key, retrieval);
    }

    @Override
    public MetaDataRetrieval removeMetaDataRetrieval(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        return this.retrievals.remove(key);
    }
}

