/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictionConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = -7979639000026975201L;
    public static final String WAKEUP_INTERVAL_SECONDS = "wakeUpIntervalSeconds";
    public static final int WAKEUP_DEFAULT = 5;
    public static final String EVENT_QUEUE_SIZE = "eventQueueSize";
    public static final String EVICTION_POLICY_CLASS = "policyClass";
    public static final int EVENT_QUEUE_SIZE_DEFAULT = 200000;
    private String defaultEvictionPolicyClass;
    private int wakeupIntervalSeconds = 5;
    private int defaultEventQueueSize = 200000;
    @Dynamic
    private List<EvictionRegionConfig> evictionRegionConfigs;

    public EvictionConfig() {
    }

    public EvictionConfig(String defaultEvictionClass) {
        this.setDefaultEvictionPolicyClass(defaultEvictionClass);
    }

    public boolean isValidConfig() {
        return this.defaultEvictionPolicyClass != null && this.defaultEvictionPolicyClass.length() > 0 || this.evictionRegionConfigs != null && this.evictionRegionConfigs.size() > 0;
    }

    public String getDefaultEvictionPolicyClass() {
        return this.defaultEvictionPolicyClass;
    }

    public void setDefaultEvictionPolicyClass(String defaultEvictionPolicyClass) {
        this.testImmutability("defaultEvictionPolicyClass");
        this.defaultEvictionPolicyClass = defaultEvictionPolicyClass;
    }

    public List<EvictionRegionConfig> getEvictionRegionConfigs() {
        if (this.evictionRegionConfigs == null && this.defaultEvictionPolicyClass != null) {
            try {
                Class<?> cpolicy = Class.forName(this.defaultEvictionPolicyClass);
                EvictionPolicy policy = (EvictionPolicy)cpolicy.newInstance();
                EvictionRegionConfig erc = new EvictionRegionConfig();
                EvictionPolicyConfig epc = policy.getEvictionConfigurationClass().newInstance();
                erc.setEvictionPolicyConfig(epc);
                erc.setRegionFqn(RegionManager.DEFAULT_REGION);
                return Collections.singletonList(erc);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        return this.evictionRegionConfigs;
    }

    public int getDefaultEventQueueSize() {
        return this.defaultEventQueueSize;
    }

    public void setDefaultEventQueueSize(int eventQueueSize) {
        this.defaultEventQueueSize = eventQueueSize;
    }

    public void setEvictionRegionConfigs(List<EvictionRegionConfig> evictionRegionConfigs) {
        this.testImmutability("evictionRegionConfigs");
        if (evictionRegionConfigs != null) {
            for (EvictionRegionConfig cfg : evictionRegionConfigs) {
                cfg.setDefaultEventQueueSize(this.getDefaultEventQueueSize());
            }
        }
        this.replaceChildConfigs(this.evictionRegionConfigs, evictionRegionConfigs);
        this.evictionRegionConfigs = evictionRegionConfigs;
    }

    public int getWakeupIntervalSeconds() {
        return this.wakeupIntervalSeconds;
    }

    public void setWakeupIntervalSeconds(int wakeupIntervalSeconds) {
        this.testImmutability("wakeupIntervalSeconds");
        this.wakeupIntervalSeconds = wakeupIntervalSeconds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvictionConfig) {
            EvictionConfig other = (EvictionConfig)obj;
            return this.wakeupIntervalSeconds == other.wakeupIntervalSeconds && EvictionConfig.safeEquals(this.defaultEvictionPolicyClass, other.defaultEvictionPolicyClass) && EvictionConfig.safeEquals(this.evictionRegionConfigs, other.evictionRegionConfigs);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.wakeupIntervalSeconds;
        result = 37 * result + (this.defaultEvictionPolicyClass == null ? 0 : this.defaultEvictionPolicyClass.hashCode());
        result = 37 * result + (this.evictionRegionConfigs == null ? 0 : ((Object)this.evictionRegionConfigs).hashCode());
        return result;
    }

    @Override
    public EvictionConfig clone() throws CloneNotSupportedException {
        EvictionConfig clone = (EvictionConfig)super.clone();
        if (this.evictionRegionConfigs != null) {
            ArrayList<EvictionRegionConfig> ercs = new ArrayList<EvictionRegionConfig>(this.evictionRegionConfigs.size());
            for (EvictionRegionConfig erc : this.evictionRegionConfigs) {
                ercs.add(erc.clone());
            }
            clone.setEvictionRegionConfigs(ercs);
        }
        return clone;
    }
}

