/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getConfiguration().getLockAcquisitionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Object retval = null;
        switch (m.getMethodId()) {
            case 18: {
                GlobalTransaction gtx = this.getGlobalTransaction(ctx);
                long timeout = this.lockAcquisitionTimeout;
                if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getLockAcquisitionTimeout() >= 0) {
                    timeout = ctx.getOptionOverrides().getLockAcquisitionTimeout();
                }
                try {
                    this.lockNodes(gtx, timeout);
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
                    try {
                        this.unlock(gtx);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"Failed to unlock nodes, after failing to lock nodes during a prepare!  Locks are possibly in a very inconsistent state now!", t);
                    }
                    throw e;
                }
                retval = super.invoke(ctx);
                break;
            }
            case 11: 
            case 12: {
                try {
                    retval = super.invoke(ctx);
                }
                catch (Throwable throwable) {
                    try {
                        this.unlock(this.getGlobalTransaction(ctx));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    this.unlock(this.getGlobalTransaction(ctx));
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
                }
                break;
            }
            case 33: {
                throw new CacheException("_lock() passed up the interceptor stack when Optimistic Locking is used.  This is NOT supported.");
            }
            default: {
                retval = super.invoke(ctx);
            }
        }
        return retval;
    }

    private void lockNodes(GlobalTransaction gtx, long timeout) throws InterruptedException {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locking nodes in transaction workspace for GlobalTransaction " + gtx));
        }
        for (WorkspaceNode workspaceNode : workspace.getNodes().values()) {
            NodeSPI node = workspaceNode.getNode();
            boolean acquired = node.getLock().acquire(gtx, this.lockAcquisitionTimeout, NodeLock.LockType.WRITE);
            if (acquired) {
                if (this.trace) {
                    this.log.trace((Object)("Acquired lock on node " + node.getFqn()));
                }
                this.cache.getTransactionTable().addLock(gtx, node.getLock());
                continue;
            }
            throw new CacheException("Unable to acquire lock on node " + node.getFqn());
        }
    }

    private void unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksFIFO(gtx);
    }
}

