/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PessimisticLockInterceptor
extends Interceptor {
    private TransactionTable tx_table = null;
    private Map<Thread, List<NodeLock>> lock_table;
    private long lock_acquisition_timeout;
    private LockManager lockManager = new LockManager();

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.tx_table = cache.getTransactionTable();
        this.lock_table = cache.getLockTable();
        this.lock_acquisition_timeout = cache.getConfiguration().getLockAcquisitionTimeout();
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Fqn fqn = null;
        NodeLock.LockType lock_type = NodeLock.LockType.NONE;
        Object[] args = m.getArgs();
        boolean lockNecessary = false;
        boolean locksAlreadyObtained = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("PessimisticLockInterceptor invoked for method " + (Object)((Object)m)));
        }
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking()) {
            this.log.trace((Object)"Suppressing locking");
            switch (m.getMethodId()) {
                case 1: 
                case 2: 
                case 3: {
                    this.log.trace((Object)"Creating nodes if necessary");
                    this.createNodes((Fqn)args[1], ctx.getGlobalTransaction());
                }
            }
            return super.invoke(ctx);
        }
        boolean recursive = false;
        boolean createIfNotExists = false;
        boolean zeroLockTimeout = false;
        boolean isDeleteOperation = false;
        boolean isEvictOperation = false;
        boolean isRemoveDataOperation = false;
        switch (m.getMethodId()) {
            case 36: {
                fqn = (Fqn)args[0];
                this.obtainLocksForMove(ctx, fqn, (Fqn)args[1]);
                locksAlreadyObtained = true;
                lockNecessary = true;
                isDeleteOperation = true;
                break;
            }
            case 45: {
                createIfNotExists = true;
                fqn = (Fqn)args[1];
                lock_type = NodeLock.LockType.WRITE;
                zeroLockTimeout = true;
                break;
            }
            case 5: {
                isDeleteOperation = true;
                fqn = (Fqn)args[1];
                lock_type = NodeLock.LockType.WRITE;
                recursive = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                createIfNotExists = true;
                fqn = (Fqn)args[1];
                lock_type = NodeLock.LockType.WRITE;
                break;
            }
            case 6: 
            case 7: {
                isRemoveDataOperation = true;
            }
            case 15: {
                fqn = (Fqn)args[1];
                lock_type = NodeLock.LockType.WRITE;
                break;
            }
            case 8: {
                zeroLockTimeout = true;
                fqn = (Fqn)args[0];
                lock_type = NodeLock.LockType.WRITE;
                isEvictOperation = true;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                lock_type = NodeLock.LockType.READ;
                break;
            }
            case 33: {
                fqn = (Fqn)args[0];
                lock_type = (NodeLock.LockType)((Object)args[1]);
                recursive = (Boolean)args[2];
                break;
            }
            case 11: {
                this.commit(ctx.getGlobalTransaction());
                break;
            }
            case 12: {
                this.rollback(ctx.getGlobalTransaction());
                break;
            }
            default: {
                if (!this.isOnePhaseCommitPrepareMehod(m)) break;
                this.commit(ctx.getGlobalTransaction());
            }
        }
        if (fqn != null) {
            if (!locksAlreadyObtained) {
                long timeout = zeroLockTimeout ? 0L : this.getLockAcquisitionTimeout(ctx);
                do {
                    this.lock(ctx, fqn, lock_type, recursive, createIfNotExists, timeout, isDeleteOperation, isEvictOperation, isRemoveDataOperation);
                } while (createIfNotExists && this.cache.peek(fqn, false) == null);
            }
        } else if (!lockNecessary && this.log.isTraceEnabled()) {
            this.log.trace((Object)("bypassed locking as method " + m.getName() + "() doesn't require locking"));
        }
        if (m.getMethodId() == 33) {
            return null;
        }
        Object o = super.invoke(ctx);
        if (isDeleteOperation && ctx.getGlobalTransaction() == null) {
            NodeSPI n = this.cache.peek(fqn, true);
            if (n != null) {
                this.lockManager.getLock(n).releaseAll(Thread.currentThread());
            }
            if (36 != m.getMethodId()) {
                ((CacheImpl)this.cache).realRemove(fqn, true);
            }
        } else if (m.getMethodId() == 11 || this.isOnePhaseCommitPrepareMehod(m) || m.getMethodId() == 12) {
            this.cleanup(ctx.getGlobalTransaction());
        }
        return o;
    }

    private long getLockAcquisitionTimeout(InvocationContext ctx) {
        long timeout = this.lock_acquisition_timeout;
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getLockAcquisitionTimeout() >= 0) {
            timeout = ctx.getOptionOverrides().getLockAcquisitionTimeout();
        }
        return timeout;
    }

    private void obtainLocksForMove(InvocationContext ctx, Fqn node, Fqn parent) throws InterruptedException {
        long timeout = this.getLockAcquisitionTimeout(ctx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to get WL on node to be moved [" + node + "]"));
        }
        this.lock(ctx, node, NodeLock.LockType.WRITE, true, false, timeout, true, false, false);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to get RL on new parent [" + parent + "]"));
        }
        this.lock(ctx, parent, NodeLock.LockType.READ, true, false, timeout, false, false, false);
    }

    private void lock(InvocationContext ctx, Fqn fqn, NodeLock.LockType lock_type, boolean recursive, boolean createIfNotExists, long timeout, boolean isDeleteOperation, boolean isEvictionOperation, boolean isRemoveDataOperation) throws TimeoutException, LockingException, InterruptedException {
        Object owner;
        Thread currentThread = Thread.currentThread();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object object = owner = gtx != null ? gtx : currentThread;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to lock node " + fqn + " for owner " + owner));
        }
        if (fqn == null) {
            this.log.error((Object)"fqn is null - this should not be the case");
            return;
        }
        if (this.configuration.getIsolationLevel() == IsolationLevel.NONE) {
            lock_type = NodeLock.LockType.NONE;
        }
        NodeSPI n = this.cache.getRoot();
        int treeNodeSize = fqn.size();
        for (int i = -1; i < treeNodeSize; ++i) {
            Set<NodeLock> acquired_locks;
            NodeSPI child_node;
            Object child_name;
            if (i == -1) {
                child_name = Fqn.ROOT.getLastElement();
                child_node = n;
            } else {
                child_name = fqn.get(i);
                child_node = n.getChildDirect(child_name);
            }
            boolean created = false;
            if (child_node == null && createIfNotExists) {
                child_node = n.addChildDirect(new Fqn<Object>(child_name));
                created = true;
            }
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n));
                }
                return;
            }
            if (lock_type == NodeLock.LockType.NONE) {
                n = child_node;
                continue;
            }
            NodeLock.LockType lockTypeRequired = created || this.writeLockNeeded(ctx, lock_type, i, treeNodeSize, isEvictionOperation, isDeleteOperation, createIfNotExists, isRemoveDataOperation, fqn, child_node) ? NodeLock.LockType.WRITE : NodeLock.LockType.READ;
            if (gtx != null && this.needToReverseRemove(child_node, this.tx_table.get(gtx), lock_type, isDeleteOperation, createIfNotExists)) {
                this.reverseRemove(child_node);
            }
            this.acquireNodeLock(child_node, owner, gtx, lockTypeRequired, timeout);
            if (recursive && this.isTargetNode(i, treeNodeSize) && (acquired_locks = this.lockManager.acquireAll(child_node, owner, lock_type, timeout)).size() > 0) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLocks(gtx, acquired_locks);
                } else {
                    List<NodeLock> locks = this.getLocks(currentThread);
                    locks.addAll(acquired_locks);
                }
            }
            n = child_node;
        }
        if (isDeleteOperation && gtx != null) {
            this.cache.getTransactionTable().get(gtx).addRemovedNode(fqn);
        }
    }

    private boolean needToReverseRemove(NodeSPI n, TransactionEntry te, NodeLock.LockType lockTypeRequested, boolean isRemoveOperation, boolean createIfNotExists) {
        return !isRemoveOperation && createIfNotExists && lockTypeRequested == NodeLock.LockType.WRITE && n.isDeleted() && te.getRemovedNodes().contains(n.getFqn());
    }

    private void reverseRemove(NodeSPI n) {
        n.markAsDeleted(false);
    }

    private boolean writeLockNeeded(InvocationContext ctx, NodeLock.LockType lock_type, int currentNodeIndex, int treeNodeSize, boolean isEvictOperation, boolean isRemoveOperation, boolean isPutOperation, boolean isRemoveDataOperation, Fqn targetFqn, NodeSPI currentNode) {
        boolean isTargetNode = this.isTargetNode(currentNodeIndex, treeNodeSize);
        if (ctx.getOptionOverrides().isForceWriteLock() && isTargetNode) {
            return true;
        }
        if (currentNode.isLockForChildInsertRemove()) {
            if (isRemoveOperation && currentNodeIndex == treeNodeSize - 2) {
                return true;
            }
            if (!isTargetNode && this.cache.peek(new Fqn<Object>(currentNode.getFqn(), targetFqn.get(currentNodeIndex + 1)), false) == null) {
                return isPutOperation;
            }
        }
        return lock_type == NodeLock.LockType.WRITE && isTargetNode && (isPutOperation || isRemoveOperation || isEvictOperation || isRemoveDataOperation);
    }

    private boolean isTargetNode(int nodePosition, int treeNodeSize) {
        return nodePosition == treeNodeSize - 1;
    }

    private void acquireNodeLock(NodeSPI node, Object owner, GlobalTransaction gtx, NodeLock.LockType lock_type, long lock_timeout) throws LockingException, TimeoutException, InterruptedException {
        boolean acquired = this.lockManager.acquire(node, owner, lock_type, lock_timeout);
        if (acquired) {
            this.recordNodeLock(gtx, this.lockManager.getLock(node));
        }
    }

    private void recordNodeLock(GlobalTransaction gtx, NodeLock lock) {
        if (gtx != null) {
            this.cache.getTransactionTable().addLock(gtx, lock);
        } else {
            Thread currentThread = Thread.currentThread();
            List<NodeLock> locks = this.getLocks(currentThread);
            if (!locks.contains(lock)) {
                locks.add(lock);
                this.lock_table.put(currentThread, locks);
            }
        }
    }

    private List<NodeLock> getLocks(Thread currentThread) {
        List<NodeLock> locks = this.lock_table.get(currentThread);
        if (locks == null) {
            locks = Collections.synchronizedList(new LinkedList());
            this.lock_table.put(currentThread, locks);
        }
        return locks;
    }

    private void createNodes(Fqn fqn, GlobalTransaction gtx) {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        NodeSPI n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            Fqn<Object> childFqn = new Fqn<Object>(child_name);
            NodeSPI child_node = n.getChildDirect(childFqn);
            if (child_node == null) {
                child_node = n.addChildDirect(childFqn);
            }
            if (gtx != null && this.needToReverseRemove(child_node, this.tx_table.get(gtx), NodeLock.LockType.WRITE, false, true)) {
                this.reverseRemove(child_node);
            }
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            n = child_node;
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        Iterator<Fqn> removedNodes = entry.getRemovedNodes().iterator();
        CacheImpl cacheImpl = (CacheImpl)this.cache;
        while (removedNodes.hasNext()) {
            Fqn f = removedNodes.next();
            cacheImpl.realRemove(f, false);
        }
    }

    private void cleanup(GlobalTransaction gtx) {
        TransactionEntry entry = this.tx_table.get(gtx);
        entry.releaseAllLocksLIFO(gtx);
    }

    private void rollback(GlobalTransaction tx) {
        TransactionEntry entry = this.tx_table.get(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + tx));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + tx + " not found (transaction has possibly already been rolled back)"));
            return;
        }
        Iterator<Fqn> removedNodes = entry.getRemovedNodes().iterator();
        CacheImpl cacheImpl = (CacheImpl)this.cache;
        while (removedNodes.hasNext()) {
            Fqn f = removedNodes.next();
            cacheImpl.realRemove(f, false);
        }
        entry.undoOperations(this.cache);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockManager {
        private LockManager() {
        }

        boolean acquire(NodeSPI node, Object owner, NodeLock.LockType lockType, long timeout) throws InterruptedException {
            return this.getLock(node).acquire(owner, timeout, lockType);
        }

        NodeLock getLock(NodeSPI node) {
            return node.getLock();
        }

        public Set<NodeLock> acquireAll(NodeSPI node, Object owner, NodeLock.LockType lockType, long timeout) throws InterruptedException {
            return this.getLock(node).acquireAll(owner, timeout, lockType);
        }
    }
}

