/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.AbstractMarshaller;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.ObjectSerializationFactory;

public class VersionAwareMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private static final int VERSION_200 = 20;
    private RegionManager manager;
    private boolean defaultInactive;
    private boolean useRegionBasedMarshalling;
    AbstractMarshaller defaultMarshaller;
    Map<Integer, Marshaller> marshallers = new HashMap<Integer, Marshaller>();
    private int versionInt;

    public VersionAwareMarshaller(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling, String version) {
        this.manager = manager;
        this.defaultInactive = defaultInactive;
        this.useRegionBasedMarshalling = useRegionBasedMarshalling;
        this.versionInt = this.toMinorVersionInt(version);
        switch (this.versionInt) {
            default: 
        }
        this.defaultMarshaller = new CacheMarshaller200(manager, defaultInactive, useRegionBasedMarshalling);
        this.marshallers.put(20, this.defaultMarshaller);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initialised with version " + version + " and versionInt " + this.versionInt));
            log.debug((Object)("Using default marshaller " + this.defaultMarshaller.getClass()));
        }
    }

    public VersionAwareMarshaller(RegionManager regionManager, Configuration configuration) {
        this(regionManager, configuration.isInactiveOnStartup(), configuration.isUseRegionBasedMarshalling(), configuration.getReplVersionString());
    }

    private int toMinorVersionInt(String version) {
        try {
            StringTokenizer strtok = new StringTokenizer(version, ".");
            String[] versionComponents = new String[]{null, null, null, null};
            int i = 0;
            while (strtok.hasMoreTokens()) {
                versionComponents[i++] = strtok.nextToken();
            }
            int major = Integer.parseInt(versionComponents[0]);
            int minor = Integer.parseInt(versionComponents[1]);
            return major > 1 || minor > 3 ? 10 * major + minor : 1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported replication version string " + version);
        }
    }

    public byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = ObjectSerializationFactory.createObjectOutputStream(bos);
        out.writeShort(this.versionInt);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out);
        out.close();
        return bos.toByteArray();
    }

    public Object objectFromByteBuffer(byte[] buf) throws Exception {
        short versionId;
        ObjectInputStream in;
        try {
            in = ObjectSerializationFactory.createObjectInputStream(buf);
            versionId = in.readShort();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream(in);
    }

    public Object objectFromStream(InputStream is) throws Exception {
        short versionId;
        ObjectInputStream in;
        try {
            in = ObjectSerializationFactory.createObjectInputStream(is);
            versionId = in.readShort();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream(in);
    }

    public void objectToObjectStream(Object obj, ObjectOutputStream out, Fqn region) throws Exception {
        out.writeShort(this.versionInt);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out, region);
    }

    Marshaller getMarshaller(int versionId) {
        switch (versionId) {
            default: 
        }
        Marshaller marshaller = this.marshallers.get(20);
        if (marshaller == null) {
            marshaller = new CacheMarshaller200(this.manager, this.defaultInactive, this.useRegionBasedMarshalling);
            this.marshallers.put(20, marshaller);
        }
        return marshaller;
    }

    public void objectToObjectStream(Object obj, ObjectOutputStream out) throws Exception {
        out.writeShort(this.versionInt);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
        short versionId;
        try {
            versionId = in.readShort();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream(in);
    }
}

