/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class ConnectionTable
extends BasicConnectionTable
implements Runnable {
    public ConnectionTable(int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTable(InetAddress bind_addr, int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.bind_addr = bind_addr;
        this.start();
    }

    public ConnectionTable(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.srv_port = srv_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public ConnectionTable(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.start();
    }

    public ConnectionTable(BasicConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicConnectionTable.Connection getConnection(Address dest) throws Exception {
        BasicConnectionTable.Connection conn = null;
        Map map = this.conns;
        synchronized (map) {
            conn = (BasicConnectionTable.Connection)this.conns.get(dest);
            if (conn == null) {
                Socket sock;
                block12: {
                    block11: {
                        InetSocketAddress tmpBindAddr = new InetSocketAddress(this.bind_addr, 0);
                        InetAddress tmpDest = ((IpAddress)dest).getIpAddress();
                        InetSocketAddress destAddr = new InetSocketAddress(tmpDest, ((IpAddress)dest).getPort());
                        sock = new Socket();
                        sock.bind(tmpBindAddr);
                        sock.setKeepAlive(true);
                        sock.setTcpNoDelay(this.tcp_nodelay);
                        if (this.linger > 0) {
                            sock.setSoLinger(true, this.linger);
                        } else {
                            sock.setSoLinger(false, -1);
                        }
                        sock.connect(destAddr, this.sock_conn_timeout);
                        try {
                            sock.setSendBufferSize(this.send_buf_size);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block11;
                            this.log.error((Object)("exception setting send buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                        }
                    }
                    try {
                        sock.setReceiveBufferSize(this.recv_buf_size);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isErrorEnabled()) break block12;
                        this.log.error((Object)("exception setting receive buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                    }
                }
                conn = new BasicConnectionTable.Connection(sock, dest);
                conn.sendLocalAddress(this.local_addr);
                this.notifyConnectionOpened(dest);
                this.addConnection(dest, conn);
                conn.init();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("created socket to " + dest));
                }
            }
            return conn;
        }
    }

    public final void start() throws Exception {
        this.init();
        this.srv_sock = this.createServerSocket(this.srv_port, this.max_port);
        this.local_addr = this.external_addr != null ? new IpAddress(this.external_addr, this.srv_sock.getLocalPort()) : (this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("server socket listening on " + this.local_addr));
        }
        this.thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "ConnectionTableGroup");
        this.acceptor = new Thread(this.thread_group, this, "ConnectionTable.AcceptorThread");
        this.acceptor.start();
        if (this.use_reaper && this.reaper == null) {
            this.reaper = new BasicConnectionTable.Reaper();
            this.reaper.start();
        }
        super.start();
    }

    protected void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket client_sock = null;
        BasicConnectionTable.Connection conn = null;
        while (this.srv_sock != null) {
            try {
                block31: {
                    block30: {
                        block29: {
                            conn = null;
                            client_sock = this.srv_sock.accept();
                            if (!this.running) {
                                if (!this.log.isWarnEnabled()) break;
                                this.log.warn((Object)("cannot accept connection from " + client_sock.getRemoteSocketAddress() + " as I'm closed"));
                                break;
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("[" + this.local_addr + "] accepted connection from " + client_sock.getInetAddress() + ":" + client_sock.getPort()));
                            }
                            try {
                                client_sock.setSendBufferSize(this.send_buf_size);
                            }
                            catch (IllegalArgumentException ex) {
                                if (!this.log.isErrorEnabled()) break block29;
                                this.log.error((Object)("exception setting send buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                            }
                        }
                        try {
                            client_sock.setReceiveBufferSize(this.recv_buf_size);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block30;
                            this.log.error((Object)("exception setting receive buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                        }
                    }
                    client_sock.setKeepAlive(true);
                    client_sock.setTcpNoDelay(this.tcp_nodelay);
                    if (this.linger > 0) {
                        client_sock.setSoLinger(true, this.linger);
                    } else {
                        client_sock.setSoLinger(false, -1);
                    }
                    conn = new BasicConnectionTable.Connection(client_sock, null);
                    Address peer_addr = conn.readPeerAddress(client_sock);
                    conn.setPeerAddress(peer_addr);
                    Map ex = this.conns;
                    synchronized (ex) {
                        BasicConnectionTable.Connection tmp = (BasicConnectionTable.Connection)this.conns.get(peer_addr);
                        if (tmp != null) {
                            if (peer_addr.compareTo(this.local_addr) > 0) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("peer's address (" + peer_addr + ") is greater than our local address (" + this.local_addr + "), replacing our existing connection"));
                                }
                                this.addConnection(peer_addr, conn);
                                tmp.destroy();
                                this.notifyConnectionOpened(peer_addr);
                                break block31;
                            } else {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("peer's address (" + peer_addr + ") is smaller than our local address (" + this.local_addr + "), rejecting peer connection request"));
                                }
                                conn.destroy();
                                continue;
                            }
                        }
                        this.addConnection(peer_addr, conn);
                        this.notifyConnectionOpened(peer_addr);
                    }
                }
                conn.init();
            }
            catch (SocketTimeoutException timeout_ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("timed out waiting for peer address, closing connection " + conn + ": " + timeout_ex));
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (SocketException sock_ex) {
                if (this.log.isWarnEnabled() && this.srv_sock != null) {
                    this.log.warn((Object)("exception is " + sock_ex));
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (Throwable ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("exception is " + ex));
                }
                if (this.srv_sock != null) continue;
            }
        }
        if (client_sock != null) {
            try {
                client_sock.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(Thread.currentThread().getName() + " terminated"));
        }
    }

    protected ServerSocket createServerSocket(int start_port, int end_port) throws Exception {
        ServerSocket ret = null;
        while (true) {
            try {
                if (this.bind_addr == null) {
                    ret = new ServerSocket(start_port);
                    break;
                }
                ret = new ServerSocket(start_port, 20, null);
            }
            catch (BindException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to");
                }
                if (this.bind_addr != null && (nic = NetworkInterface.getByInetAddress(this.bind_addr)) == null) {
                    throw new BindException("bind_addr " + this.bind_addr + " is not a valid interface");
                }
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        this.srv_port = start_port;
        return ret;
    }
}

