/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.stack.IpAddress;

public class TCP
extends BasicTCP
implements BasicConnectionTable.Receiver {
    private ConnectionTable ct = null;

    public String getName() {
        return "TCP";
    }

    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }

    public String printConnections() {
        return this.ct.toString();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.ct.send(dest, data, offset, length);
    }

    public void retainAll(Collection members) {
        this.ct.retainAll(members);
    }

    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.start_port, this.end_port);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setSendQueueSize(this.send_queue_size);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.ct.setPeerAddressReadTimeout(this.peer_addr_read_timeout);
        this.ct.setTcpNodelay(this.tcp_nodelay);
        this.ct.setLinger(this.linger);
        this.local_addr = this.ct.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        super.start();
    }

    public void stop() {
        this.ct.stop();
        super.stop();
    }

    protected ConnectionTable getConnectionTable(long reaperInterval, long connExpireTime, InetAddress bindAddress, InetAddress externalAddress, int startPort, int endPort) throws Exception {
        ConnectionTable cTable;
        if (reaperInterval == 0L && connExpireTime == 0L) {
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort);
        } else {
            if (reaperInterval == 0L) {
                reaperInterval = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("reaper_interval was 0, set it to " + reaperInterval));
                }
            }
            if (connExpireTime == 0L) {
                connExpireTime = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("conn_expire_time was 0, set it to " + connExpireTime));
                }
            }
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort, reaperInterval, connExpireTime);
        }
        return cTable;
    }
}

