/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencerOrderTest
extends TestCase {
    private JChannel ch1;
    private JChannel ch2;
    private MyReceiver r1;
    private MyReceiver r2;
    static final String GROUP = "demo-group";
    static final int NUM_MSGS = 1000;
    String props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=2;mcast_send_buf_size=25000000;mcast_recv_buf_size=640000;enable_bundling=true;use_incoming_packet_handler=true;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD(timeout=2000;max_tries=2):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=5000):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true;view_ack_collection_timeout=2000):SEQUENCER";

    public SequencerOrderTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel(this.props);
        this.ch1.connect(GROUP);
        this.ch2 = new JChannel(this.props);
        this.ch2.connect(GROUP);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.ch2 != null) {
            this.ch2.close();
            this.ch2 = null;
        }
        if (this.ch1 != null) {
            this.ch1.close();
            this.ch1 = null;
        }
    }

    public void testBroadcastSequence() throws Exception {
        this.r1 = new MyReceiver(this.ch1.getLocalAddress());
        this.ch1.setReceiver(this.r1);
        this.r2 = new MyReceiver(this.ch2.getLocalAddress());
        this.ch2.setReceiver(this.r2);
        Thread thread1 = new Thread(){

            public void run() {
                Util.sleep(300L);
                for (int i = 1; i <= 1000; ++i) {
                    try {
                        SequencerOrderTest.this.ch1.send(new Message(null, null, new Integer(i)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    System.out.print("-- messages sent thread 1: " + i + "/" + 1000 + "\r");
                }
            }
        };
        Thread thread2 = new Thread(){

            public void run() {
                Util.sleep(300L);
                for (int i = 1; i <= 1000; ++i) {
                    try {
                        SequencerOrderTest.this.ch1.send(new Message(null, null, new Integer(i)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    System.out.print("-- messages sent thread 2: " + i + "/" + 1000 + "\r");
                }
            }
        };
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        System.out.println("");
        System.out.println("-- verifying messages on ch1 and ch2");
        this.verifyNumberOfMessages(2000);
        this.verifyMessageOrder(this.r1.getMsgs());
        this.verifyMessageOrder(this.r2.getMsgs());
        this.verifySameOrder();
    }

    private void verifyNumberOfMessages(int num_msgs) throws Exception {
        List<Integer> l1 = this.r1.getMsgs();
        List<Integer> l2 = this.r2.getMsgs();
        long end_time = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < end_time && (l1.size() < num_msgs || l2.size() < num_msgs)) {
            Util.sleep(500L);
        }
        System.out.println("l1.size()=" + l1.size() + ", l2.size()=" + l2.size());
        SequencerOrderTest.assertEquals((String)("list 1 should have " + num_msgs + " elements"), (int)num_msgs, (int)l1.size());
        SequencerOrderTest.assertEquals((String)("list 2 should have " + num_msgs + " elements"), (int)num_msgs, (int)l2.size());
    }

    private void verifyMessageOrder(List<Integer> list) throws Exception {
        List<Integer> l1 = this.r1.getMsgs();
        List<Integer> l2 = this.r2.getMsgs();
        System.out.println("l1: " + l1);
        System.out.println("l2: " + l2);
        int i = 1;
        int j = 1;
        for (int count : list) {
            if (count == i) {
                ++i;
                continue;
            }
            if (count == j) {
                ++j;
                continue;
            }
            throw new Exception("got " + count + ", but expected " + i + " or " + j);
        }
    }

    private void verifySameOrder() throws Exception {
        List<Integer> l1 = this.r1.getMsgs();
        List<Integer> l2 = this.r2.getMsgs();
        int[] arr1 = new int[l1.size()];
        int[] arr2 = new int[l2.size()];
        int index = 0;
        for (int el : l1) {
            arr1[index++] = el;
        }
        index = 0;
        for (int el : l2) {
            arr2[index++] = el;
        }
        for (int i = 0; i < arr1.length; ++i) {
            int count1 = arr1[i];
            int count2 = arr2[i];
            if (count1 == count2) continue;
            throw new Exception("lists are different at index " + i + ": count1=" + count1 + ", count2=" + count2);
        }
    }

    public static void main(String[] args) {
        String[] name = new String[]{SequencerOrderTest.class.getName()};
        TestRunner.main((String[])name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        Address local_addr;
        List<Integer> msgs = new LinkedList<Integer>();

        private MyReceiver(Address local_addr) {
            this.local_addr = local_addr;
        }

        public List<Integer> getMsgs() {
            return this.msgs;
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add((Integer)msg.getObject());
        }
    }
}

