/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promise<T> {
    T result = null;
    volatile boolean hasResult = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getResultWithTimeout(long timeout) throws TimeoutException {
        Promise promise = this;
        synchronized (promise) {
            T t = this._getResultWithTimeout(timeout);
            return t;
            finally {
                this.notifyAll();
            }
        }
    }

    private T _getResultWithTimeout(long timeout) throws TimeoutException {
        T ret = null;
        long time_to_wait = timeout;
        boolean timeout_occurred = false;
        long start = System.currentTimeMillis();
        while (!this.hasResult) {
            if (timeout <= 0L) {
                this.doWait();
                continue;
            }
            if (time_to_wait <= 0L) {
                timeout_occurred = true;
                break;
            }
            this.doWait(time_to_wait);
            time_to_wait = timeout - (System.currentTimeMillis() - start);
        }
        ret = this.result;
        this.result = null;
        this.hasResult = false;
        if (timeout_occurred) {
            throw new TimeoutException();
        }
        return ret;
    }

    public T getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public T getResult(long timeout) {
        try {
            return this.getResultWithTimeout(timeout);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void doWait(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult() {
        Promise promise = this;
        synchronized (promise) {
            return this.hasResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T obj) {
        Promise promise = this;
        synchronized (promise) {
            this.result = obj;
            this.hasResult = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Promise promise = this;
        synchronized (promise) {
            this.result = null;
            this.hasResult = false;
            this.notifyAll();
        }
    }

    public String toString() {
        return "hasResult=" + Boolean.valueOf(this.hasResult) + ",result=" + this.result;
    }
}

