/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;

public class Counter
implements Serializable,
Cloneable {
    private int count;

    public Counter(int count) {
        this.count = count;
    }

    public Counter() {
    }

    public int increment() {
        return ++this.count;
    }

    public int decrement() {
        return --this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((Counter)obj).count == this.count;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.count);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static Counter makeSynchronized(Counter counter) {
        return new Wrapper(counter){

            public synchronized int increment() {
                return this.counter.increment();
            }

            public synchronized int decrement() {
                return this.counter.decrement();
            }

            public synchronized int getCount() {
                return this.counter.getCount();
            }

            public synchronized void reset() {
                this.counter.reset();
            }

            public synchronized int hashCode() {
                return this.counter.hashCode();
            }

            public synchronized boolean equals(Object obj) {
                return this.counter.equals(obj);
            }

            public synchronized String toString() {
                return this.counter.toString();
            }

            public synchronized Object clone() {
                return this.counter.clone();
            }
        };
    }

    public static Counter makeDirectional(Counter counter, boolean increasing) {
        Wrapper temp = increasing ? new Wrapper(counter){

            public int decrement() {
                throw new UnsupportedOperationException();
            }

            public void reset() {
                throw new UnsupportedOperationException();
            }
        } : new Wrapper(counter){

            public int increment() {
                throw new UnsupportedOperationException();
            }
        };
        return temp;
    }

    private static class Wrapper
    extends Counter {
        protected final Counter counter;

        public Wrapper(Counter counter) {
            this.counter = counter;
        }

        public int increment() {
            return this.counter.increment();
        }

        public int decrement() {
            return this.counter.decrement();
        }

        public int getCount() {
            return this.counter.getCount();
        }

        public void reset() {
            this.counter.reset();
        }

        public boolean equals(Object obj) {
            return this.counter.equals(obj);
        }

        public String toString() {
            return this.counter.toString();
        }

        public Object clone() {
            return this.counter.clone();
        }
    }
}

