/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.TruncateResult;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DbTree
implements LoggableObject,
LogReadable {
    public static final DatabaseId ID_DB_ID;
    public static final DatabaseId NAME_DB_ID;
    public static final String ID_DB_NAME = "_jeIdMap";
    public static final String NAME_DB_NAME = "_jeNameMap";
    public static final String UTILIZATION_DB_NAME = "_jeUtilization";
    private static final String[] RESERVED_DB_NAMES;
    private int lastAllocatedDbId;
    private DatabaseImpl idDatabase;
    private DatabaseImpl nameDatabase;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbTree() throws DatabaseException {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.nameDatabase = new DatabaseImpl();
    }

    public DbTree(EnvironmentImpl env) throws DatabaseException {
        this.envImpl = env;
        this.idDatabase = new DatabaseImpl(ID_DB_NAME, new DatabaseId(0), env, new DatabaseConfig());
        this.nameDatabase = new DatabaseImpl(NAME_DB_NAME, new DatabaseId(1), env, new DatabaseConfig());
        this.lastAllocatedDbId = 1;
    }

    public synchronized int getLastDbId() {
        return this.lastAllocatedDbId;
    }

    private synchronized int getNextDbId() {
        return ++this.lastAllocatedDbId;
    }

    public synchronized void setLastDbId(int maxDbId) {
        this.lastAllocatedDbId = maxDbId;
    }

    void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.idDatabase.setEnvironmentImpl(envImpl);
        this.nameDatabase.setEnvironmentImpl(envImpl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        Locker autoTxn;
        boolean operationOk;
        CursorImpl nameCursor;
        DatabaseImpl newDb;
        block9: {
            DatabaseId newId = new DatabaseId(this.getNextDbId());
            newDb = new DatabaseImpl(databaseName, newId, this.envImpl, dbConfig);
            CursorImpl idCursor = null;
            nameCursor = null;
            operationOk = false;
            autoTxn = null;
            try {
                try {
                    nameCursor = new CursorImpl(this.nameDatabase, locker);
                    NameLN nameLN = new NameLN(newId);
                    nameCursor.putLN(new Key(databaseName.getBytes("UTF-8")), nameLN, false);
                    if (databaseHandle != null) {
                        locker.addToHandleMaps(new Long(nameLN.getNodeId()), databaseHandle);
                    }
                    autoTxn = new AutoTxn(this.envImpl, new TransactionConfig());
                    idCursor = new CursorImpl(this.idDatabase, autoTxn);
                    idCursor.putLN(new Key(newId.getBytes()), new MapLN(newDb), false);
                    operationOk = true;
                }
                catch (UnsupportedEncodingException UEE) {
                    throw new DatabaseException(UEE);
                }
                Object var13_13 = null;
                if (idCursor == null) break block9;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (idCursor != null) {
                    idCursor.close();
                }
                if (nameCursor != null) {
                    nameCursor.close();
                }
                if (autoTxn == null) throw throwable;
                autoTxn.operationEnd(operationOk);
                throw throwable;
            }
            idCursor.close();
        }
        if (nameCursor != null) {
            nameCursor.close();
        }
        if (autoTxn == null) return newDb;
        autoTxn.operationEnd(operationOk);
        return newDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
            this.envImpl.logMapTreeRoot();
        } else {
            boolean operationOk;
            AutoTxn locker;
            block12: {
                locker = new AutoTxn(this.envImpl, new TransactionConfig());
                CursorImpl cursor = new CursorImpl(this.idDatabase, locker);
                operationOk = false;
                try {
                    DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
                    MapLN mapLN = null;
                    while (true) {
                        try {
                            boolean searchOk;
                            boolean bl = searchOk = (cursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                            if (!$assertionsDisabled && !searchOk) {
                                throw new AssertionError((Object)("can't find database " + db.getId()));
                            }
                            mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                        }
                        catch (DeadlockException DE) {
                            cursor.close();
                            ((Locker)locker).operationEnd(false);
                            locker = new AutoTxn(this.envImpl, new TransactionConfig());
                            cursor = new CursorImpl(this.idDatabase, locker);
                            continue;
                        }
                        finally {
                            cursor.releaseBINs();
                            continue;
                        }
                        break;
                    }
                    RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                    mapLN.getDatabase().getTree().withRootLatched(writeMapLN);
                    operationOk = true;
                    Object var10_11 = null;
                    if (cursor == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    ((Locker)locker).operationEnd(operationOk);
                    throw throwable;
                }
                cursor.close();
            }
            ((Locker)locker).operationEnd(operationOk);
            {
            }
        }
    }

    private NameLockResult lockNameLN(Locker locker, String databaseName, String action) throws DatabaseException {
        NameLockResult result = new NameLockResult();
        result.dbImpl = this.getDb(locker, databaseName, null);
        if (result.dbImpl == null) {
            throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
        }
        result.nameCursor = new CursorImpl(this.nameDatabase, locker);
        try {
            boolean found;
            DatabaseEntry key = new DatabaseEntry(databaseName.getBytes("UTF-8"));
            boolean bl = found = (result.nameCursor.searchAndPosition(key, null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
            if (!found) {
                result.nameCursor.releaseBIN();
                result.nameCursor.close();
                result.nameCursor = null;
                return result;
            }
            result.nameLN = (NameLN)result.nameCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
            int handleCount = result.dbImpl.getReferringHandleCount();
            if (handleCount > 0) {
                throw new DatabaseException("Can't " + action + " database " + databaseName + "," + handleCount + " open Dbs exist");
            }
        }
        catch (UnsupportedEncodingException UEE) {
            result.nameCursor.releaseBIN();
            result.nameCursor.close();
            throw new DatabaseException(UEE);
        }
        catch (DatabaseException e) {
            result.nameCursor.releaseBIN();
            result.nameCursor.close();
            throw e;
        }
        return result;
    }

    boolean dbRename(Locker locker, String databaseName, String newName) throws DatabaseException {
        boolean bl;
        block7: {
            NameLockResult result;
            CursorImpl nameCursor;
            block5: {
                boolean bl2;
                block6: {
                    nameCursor = null;
                    result = this.lockNameLN(locker, databaseName, "rename");
                    nameCursor = result.nameCursor;
                    if (nameCursor != null) break block5;
                    bl2 = false;
                    Object var8_9 = null;
                    if (nameCursor == null) break block6;
                    nameCursor.releaseBIN();
                    nameCursor.close();
                }
                return bl2;
            }
            try {
                nameCursor.delete();
                nameCursor.putLN(new Key(newName.getBytes("UTF-8")), new NameLN(result.dbImpl.getId()), false);
                bl = true;
                Object var8_10 = null;
                if (nameCursor == null) break block7;
            }
            catch (UnsupportedEncodingException UEE) {
                try {
                    throw new DatabaseException(UEE);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var8_11 = null;
                        if (nameCursor == null) break block8;
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    throw throwable;
                }
            }
            nameCursor.releaseBIN();
            nameCursor.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dbRemove(Locker locker, String databaseName) throws DatabaseException {
        CursorImpl nameCursor;
        block4: {
            block3: {
                nameCursor = null;
                try {
                    NameLockResult result = this.lockNameLN(locker, databaseName, "remove");
                    nameCursor = result.nameCursor;
                    if (nameCursor == null) {
                        Object var6_5 = null;
                        if (nameCursor == null) return;
                        break block3;
                    }
                    nameCursor.delete();
                    result.dbImpl.recordObsoleteNodes();
                    locker.markDeleteAtTxnEnd(result.dbImpl, true, this.envImpl.getMemoryBudget());
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (nameCursor == null) throw throwable;
                    nameCursor.releaseBIN();
                    nameCursor.close();
                    throw throwable;
                }
            }
            nameCursor.releaseBIN();
            nameCursor.close();
            return;
        }
        Object var6_6 = null;
        if (nameCursor == null) return;
        nameCursor.releaseBIN();
        nameCursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long truncate(Locker locker, String databaseName) throws DatabaseException {
        long l;
        block13: {
            NameLockResult result;
            AutoTxn autoTxn;
            CursorImpl nameCursor;
            block10: {
                long l2;
                block11: {
                    nameCursor = null;
                    autoTxn = null;
                    result = this.lockNameLN(locker, databaseName, "truncate");
                    nameCursor = result.nameCursor;
                    if (nameCursor != null) break block10;
                    l2 = 0L;
                    Object var15_9 = null;
                    if (nameCursor == null) break block11;
                    nameCursor.releaseBIN();
                    nameCursor.close();
                }
                return l2;
            }
            try {
                boolean operationOk;
                DatabaseImpl newDb;
                block12: {
                    DatabaseId newId = new DatabaseId(this.getNextDbId());
                    newDb = (DatabaseImpl)result.dbImpl.clone();
                    newDb.setId(newId);
                    newDb.setTree(new Tree(newDb));
                    CursorImpl idCursor = null;
                    operationOk = false;
                    try {
                        autoTxn = new AutoTxn(this.envImpl, new TransactionConfig());
                        idCursor = new CursorImpl(this.idDatabase, autoTxn);
                        idCursor.putLN(new Key(newId.getBytes()), new MapLN(newDb), false);
                        operationOk = true;
                        Object var11_15 = null;
                        if (idCursor == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        if (idCursor != null) {
                            idCursor.close();
                        }
                        if (autoTxn != null) {
                            autoTxn.operationEnd(operationOk);
                        }
                        throw throwable;
                    }
                    idCursor.close();
                }
                if (autoTxn != null) {
                    autoTxn.operationEnd(operationOk);
                }
                result.nameLN.setId(newDb.getId());
                int recordCount = result.dbImpl.recordObsoleteNodes();
                locker.markDeleteAtTxnEnd(result.dbImpl, true, this.envImpl.getMemoryBudget());
                locker.markDeleteAtTxnEnd(newDb, false, this.envImpl.getMemoryBudget());
                DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
                nameCursor.putCurrent(dataDbt, null, null);
                l = recordCount;
                Object var15_10 = null;
                if (nameCursor == null) break block13;
            }
            catch (CloneNotSupportedException CNSE) {
                try {
                    throw new DatabaseException(CNSE);
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var15_11 = null;
                        if (nameCursor == null) break block14;
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    throw throwable;
                }
            }
            nameCursor.releaseBIN();
            nameCursor.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMapLN(DatabaseId id) throws DatabaseException {
        boolean operationOk;
        AutoTxn autoTxn;
        block6: {
            autoTxn = null;
            operationOk = false;
            CursorImpl idCursor = null;
            try {
                boolean found;
                autoTxn = new AutoTxn(this.envImpl, new TransactionConfig());
                idCursor = new CursorImpl(this.idDatabase, autoTxn);
                boolean bl = found = (idCursor.searchAndPosition(new DatabaseEntry(id.getBytes()), null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                if (found) {
                    idCursor.delete();
                }
                operationOk = true;
                Object var7_6 = null;
                if (idCursor == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (idCursor != null) {
                    idCursor.close();
                }
                if (autoTxn != null) {
                    autoTxn.operationEnd(operationOk);
                }
                throw throwable;
            }
            idCursor.close();
        }
        if (autoTxn != null) {
            autoTxn.operationEnd(operationOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TruncateResult truncate(Locker locker, DatabaseImpl oldDatabase) throws DatabaseException {
        CursorImpl nameCursor = new CursorImpl(this.nameDatabase, locker);
        try {
            AutoTxn autoTxn;
            boolean operationOk;
            DatabaseImpl newDb;
            NameLN nameLN;
            block13: {
                boolean found;
                String databaseName = this.getDbName(oldDatabase.getId());
                DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                if (!found) {
                    throw new DatabaseException("Database " + databaseName + " not found in map tree");
                }
                nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                int handleCount = oldDatabase.getReferringHandleCount();
                if (handleCount > 1) {
                    throw new DatabaseException("Can't truncate database " + databaseName + "," + handleCount + " open databases exist");
                }
                DatabaseId newId = new DatabaseId(this.getNextDbId());
                newDb = (DatabaseImpl)oldDatabase.clone();
                newDb.setId(newId);
                newDb.setTree(new Tree(newDb));
                CursorImpl idCursor = null;
                operationOk = false;
                autoTxn = null;
                try {
                    autoTxn = new AutoTxn(this.envImpl, new TransactionConfig());
                    idCursor = new CursorImpl(this.idDatabase, autoTxn);
                    idCursor.putLN(new Key(newId.getBytes()), new MapLN(newDb), false);
                    operationOk = true;
                    Object var15_16 = null;
                    if (idCursor == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    if (idCursor != null) {
                        idCursor.close();
                    }
                    if (autoTxn != null) {
                        autoTxn.operationEnd(operationOk);
                    }
                    throw throwable;
                }
                idCursor.close();
            }
            if (autoTxn != null) {
                autoTxn.operationEnd(operationOk);
            }
            nameLN.setId(newDb.getId());
            int recordCount = oldDatabase.recordObsoleteNodes();
            locker.markDeleteAtTxnEnd(oldDatabase, true, this.envImpl.getMemoryBudget());
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.putCurrent(dataDbt, null, null);
            TruncateResult truncateResult = new TruncateResult(newDb, recordCount);
            return truncateResult;
        }
        catch (CloneNotSupportedException CNSE) {
            throw new DatabaseException(CNSE);
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
        finally {
            nameCursor.releaseBIN();
            nameCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, Database databaseHandle) throws DatabaseException {
        try {
            DatabaseId id;
            block8: {
                CursorImpl nameCursor = null;
                id = null;
                try {
                    boolean found;
                    nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                    DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                    boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                    if (found) {
                        NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockType.READ);
                        id = nameLN.getId();
                        if (databaseHandle != null) {
                            nameLocker.addToHandleMaps(new Long(nameLN.getNodeId()), databaseHandle);
                        }
                    }
                    Object var10_10 = null;
                    if (nameCursor == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (nameCursor != null) {
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    throw throwable;
                }
                nameCursor.releaseBIN();
                nameCursor.close();
            }
            if (id == null) {
                return null;
            }
            return this.getDb(id, -1L);
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        BasicLocker locker = new BasicLocker(this.envImpl);
        if (lockTimeout != -1L) {
            locker.setLockTimeout(lockTimeout);
        }
        if (dbId.equals(this.idDatabase.getId())) {
            return this.idDatabase;
        }
        if (dbId.equals(this.nameDatabase.getId())) {
            return this.nameDatabase;
        }
        CursorImpl idCursor = null;
        while (true) {
            try {
                boolean found;
                idCursor = new CursorImpl(this.idDatabase, locker);
                DatabaseEntry keyDbt = new DatabaseEntry(dbId.getBytes());
                boolean bl = found = (idCursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                if (found) {
                    MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.READ);
                    DatabaseImpl databaseImpl = mapLN.getDatabase();
                    return databaseImpl;
                }
                DatabaseImpl databaseImpl = null;
                return databaseImpl;
            }
            catch (DeadlockException DE) {
                idCursor.close();
                ((Locker)locker).operationEnd(false);
                locker = new BasicLocker(this.envImpl);
                if (lockTimeout != -1L) {
                    locker.setLockTimeout(lockTimeout);
                }
                idCursor = new CursorImpl(this.idDatabase, locker);
                continue;
            }
            finally {
                idCursor.releaseBIN();
                idCursor.close();
                ((Locker)locker).operationEnd(true);
                continue;
            }
            break;
        }
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = true;
        try {
            this.idDatabase.verify(config);
            this.nameDatabase.verify(config);
        }
        catch (DatabaseException DE) {
            ret = false;
        }
        INCompressor iNCompressor = this.envImpl.getINCompressor();
        synchronized (iNCompressor) {
            block13: {
                BasicLocker locker;
                block11: {
                    locker = null;
                    CursorImpl cursor = null;
                    LockType lockType = LockType.NONE;
                    try {
                        try {
                            locker = new BasicLocker(this.envImpl);
                            cursor = new CursorImpl(this.idDatabase, locker);
                            cursor.positionFirstOrLast(true, null);
                            MapLN mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(lockType);
                            DatabaseEntry keyDbt = new DatabaseEntry();
                            DatabaseEntry dataDbt = new DatabaseEntry();
                            while (mapLN != null) {
                                mapLN.getDatabase().verify(config);
                                OperationStatus status = cursor.getNext(keyDbt, dataDbt, lockType, true, false);
                                if (status != OperationStatus.SUCCESS) break;
                                mapLN = (MapLN)cursor.getCurrentLN(lockType);
                            }
                            Object var13_14 = null;
                            if (cursor == null) break block11;
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace(out);
                            ret = false;
                            Object var13_15 = null;
                            if (cursor != null) {
                                cursor.releaseBINs();
                                cursor.close();
                            }
                            if (locker == null) return ret;
                            ((Locker)locker).operationEnd();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        if (cursor != null) {
                            cursor.releaseBINs();
                            cursor.close();
                        }
                        if (locker == null) throw throwable;
                        ((Locker)locker).operationEnd();
                        throw throwable;
                    }
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker == null) return ret;
                ((Locker)locker).operationEnd();
            }
            return ret;
        }
    }

    public String getDbName(DatabaseId id) throws DatabaseException {
        String string;
        BasicLocker locker;
        block10: {
            if (id.equals(ID_DB_ID)) {
                return ID_DB_NAME;
            }
            if (id.equals(NAME_DB_ID)) {
                return NAME_DB_NAME;
            }
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.envImpl);
                cursor = new CursorImpl(this.nameDatabase, locker);
                DatabaseEntry keyDbt = new DatabaseEntry();
                DatabaseEntry dataDbt = new DatabaseEntry();
                String name = null;
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status;
                    cursor.getCurrentAlreadyLatched(keyDbt, dataDbt, LockType.NONE, true);
                    do {
                        NameLN nameLN;
                        if (!(nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE)).getId().equals(id)) continue;
                        name = new String(keyDbt.getData(), "UTF-8");
                        break;
                    } while ((status = cursor.getNext(keyDbt, dataDbt, LockType.NONE, true, false)) == OperationStatus.SUCCESS);
                }
                string = name;
                Object var10_10 = null;
                if (cursor == null) break block10;
            }
            catch (UnsupportedEncodingException UEE) {
                try {
                    throw new DatabaseException(UEE);
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var10_11 = null;
                        if (cursor != null) {
                            cursor.releaseBINs();
                            cursor.close();
                        }
                        if (locker == null) break block11;
                        ((Locker)locker).operationEnd();
                    }
                    throw throwable;
                }
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        return string;
    }

    public List getDbNames() throws DatabaseException {
        ArrayList<String> arrayList;
        BasicLocker locker;
        block8: {
            ArrayList<String> nameList = new ArrayList<String>();
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.envImpl);
                cursor = new CursorImpl(this.nameDatabase, locker);
                DatabaseEntry keyDbt = new DatabaseEntry();
                DatabaseEntry dataDbt = new DatabaseEntry();
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status;
                    cursor.getCurrentAlreadyLatched(keyDbt, dataDbt, LockType.READ, true);
                    do {
                        String name;
                        if (this.isReservedDbName(name = new String(keyDbt.getData(), "UTF-8"))) continue;
                        nameList.add(name);
                    } while ((status = cursor.getNext(keyDbt, dataDbt, LockType.READ, true, false)) == OperationStatus.SUCCESS);
                }
                arrayList = nameList;
                Object var9_9 = null;
                if (cursor == null) break block8;
            }
            catch (UnsupportedEncodingException UEE) {
                try {
                    throw new DatabaseException(UEE);
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var9_10 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (locker == null) break block9;
                        ((Locker)locker).operationEnd();
                    }
                    throw throwable;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        return arrayList;
    }

    public boolean isReservedDbName(String name) {
        for (int i = 0; i < RESERVED_DB_NAMES.length; ++i) {
            if (!RESERVED_DB_NAMES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getHighestLevel() throws DatabaseException {
        RootLevel getLevel = new RootLevel(this.idDatabase);
        this.idDatabase.getTree().withRootLatched(getLevel);
        int idHighLevel = getLevel.getRootLevel();
        getLevel = new RootLevel(this.nameDatabase);
        this.nameDatabase.getTree().withRootLatched(getLevel);
        int nameHighLevel = getLevel.getRootLevel();
        return nameHighLevel > idHighLevel ? nameHighLevel : idHighLevel;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_ROOT;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public int getLogSize() {
        return LogUtils.getIntLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeInt(logBuffer, this.lastAllocatedDbId);
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
    }

    public void postLogWork(long justLoggedLsn) throws DatabaseException {
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.lastAllocatedDbId = LogUtils.readInt(itemBuffer);
        this.idDatabase.readFromLog(itemBuffer);
        this.nameDatabase.readFromLog(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<dbtree lastId = \"");
        sb.append(this.lastAllocatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    String dumpString(int nSpaces) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() throws DatabaseException {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    static {
        $assertionsDisabled = !DbTree.class.desiredAssertionStatus();
        ID_DB_ID = new DatabaseId(0);
        NAME_DB_ID = new DatabaseId(1);
        RESERVED_DB_NAMES = new String[]{ID_DB_NAME, NAME_DB_NAME, UTILIZATION_DB_NAME};
    }

    private static class RootLevel
    implements WithRootLatched {
        private DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    private static class NameLockResult {
        CursorImpl nameCursor;
        DatabaseImpl dbImpl;
        NameLN nameLN;

        private NameLockResult() {
        }
    }

    private static class RewriteMapLN
    implements WithRootLatched {
        private CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.putCurrent(dataDbt, null, null);
            return null;
        }
    }
}

