/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.impl.MethodDeclarations;
import org.jboss.cache.pojo.interceptors.AbstractInterceptor;
import org.jboss.cache.pojo.interceptors.PojoTxSynchronizationHandler;
import org.jboss.cache.pojo.interceptors.PojoTxUndoSynchronizationInterceptor;
import org.jboss.cache.pojo.util.MethodCall;

public class PojoTxUndoInterceptor
extends AbstractInterceptor {
    public static final String TAG = "PojoCache";

    public Object invoke(Invocation in) throws Throwable {
        if (!(in instanceof MethodInvocation)) {
            throw new IllegalArgumentException("TxUndoInterceptor.invoke(): invocation not MethodInvocation");
        }
        MethodInvocation invocation = (MethodInvocation)in;
        PojoTxSynchronizationHandler handler = PojoTxUndoSynchronizationInterceptor.getSynchronizationHandler();
        if (handler == null) {
            return invocation.invokeNext();
        }
        String methodName = invocation.getMethod().getName();
        if (methodName.equals(MethodDeclarations.attachInterceptor.getName())) {
            Method method = MethodDeclarations.undoAttachInterceptor;
            MethodCall mc = new MethodCall(method, invocation.getArguments(), invocation.getTargetObject());
            handler.addToList(mc);
        } else if (methodName.equals(MethodDeclarations.detachInterceptor.getName())) {
            Method method = MethodDeclarations.undoDetachInterceptor;
            MethodCall mc = new MethodCall(method, invocation.getArguments(), invocation.getTargetObject());
            handler.addToList(mc);
        } else if (methodName.equals(MethodDeclarations.inMemorySubstitution.getName())) {
            Method method = MethodDeclarations.undoInMemorySubstitution;
            Object obj = invocation.getArguments()[0];
            Field field = (Field)invocation.getArguments()[1];
            Object oldValue = field.get(obj);
            Object[] args = new Object[]{obj, field, oldValue};
            MethodCall mc = new MethodCall(method, args, invocation.getTargetObject());
            handler.addToList(mc);
        } else if (methodName.equals(MethodDeclarations.incrementReferenceCount.getName())) {
            Method method = MethodDeclarations.undoIncrementReferenceCount;
            Fqn fqn = (Fqn)invocation.getArguments()[0];
            int count = (Integer)invocation.getArguments()[1];
            List referenceList = (List)invocation.getArguments()[2];
            Object[] args = new Object[]{fqn, count, referenceList};
            MethodCall mc = new MethodCall(method, args, invocation.getTargetObject());
            handler.addToList(mc);
        } else if (methodName.equals(MethodDeclarations.decrementReferenceCount.getName())) {
            Method method = MethodDeclarations.undoDecrementReferenceCount;
            Fqn fqn = (Fqn)invocation.getArguments()[0];
            int count = (Integer)invocation.getArguments()[1];
            List referenceList = (List)invocation.getArguments()[2];
            Object[] args = new Object[]{fqn, count, referenceList};
            MethodCall mc = new MethodCall(method, args, invocation.getTargetObject());
            handler.addToList(mc);
        } else {
            throw new PojoCacheException("PojoTxUndoInterceptor: invalid invocation name: " + methodName);
        }
        return invocation.invokeNext();
    }
}

