/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static Driver _driverModule;

    public boolean acceptsURL(String string) throws SQLException {
        return AutoloadedDriver.isBooted() && InternalDriver.embeddedDriverAcceptsURL(string);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(string)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(string, properties);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(string, properties);
    }

    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public static Driver getDriverModule() throws SQLException {
        if (_engineForcedDown) {
            throw new SQLException(MessageService.getTextMessage("I015"));
        }
        if (!AutoloadedDriver.isBooted()) {
            EmbeddedDriver.boot();
        }
        return _driverModule;
    }

    protected static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
    }

    protected static void unregisterDriverModule() {
        _driverModule = null;
        _engineForcedDown = true;
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    static {
        try {
            DriverManager.registerDriver(new AutoloadedDriver());
        }
        catch (SQLException sQLException) {
            String string = MessageService.getTextMessage("I026", sQLException.getMessage());
            throw new IllegalStateException(string);
        }
    }
}

