/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.interceptors.CacheMgmtInterceptorMBean;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMgmtInterceptor
extends MethodDispacherInterceptor
implements CacheMgmtInterceptorMBean {
    private long m_hit_times = 0L;
    private long m_miss_times = 0L;
    private long m_store_times = 0L;
    private long m_hits = 0L;
    private long m_misses = 0L;
    private long m_stores = 0L;
    private long m_evictions = 0L;
    private long m_start;
    private long m_reset = this.m_start = System.currentTimeMillis();

    public CacheMgmtInterceptor() {
        this.initLogger();
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        return !this.getStatisticsEnabled();
    }

    @Override
    protected Object handleEvictMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        ++this.m_evictions;
        return returnValue;
    }

    @Override
    protected Object handleEvictVersionedNodeMethod(InvocationContext ctx, Fqn fqn, DataVersion dataVersion) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        ++this.m_evictions;
        return returnValue;
    }

    @Override
    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = super.nextInterceptor(ctx);
        long t2 = System.currentTimeMillis();
        if (retval == null) {
            this.m_miss_times += t2 - t1;
            ++this.m_misses;
        } else {
            this.m_hit_times += t2 - t1;
            ++this.m_hits;
        }
        return retval;
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        return this.handlePutData(ctx, data);
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        return this.handlePutData(ctx, newData);
    }

    private Object handlePutData(InvocationContext ctx, Map data) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.nextInterceptor(ctx);
        long t2 = System.currentTimeMillis();
        if (data != null && data.size() > 0) {
            this.m_store_times += t2 - t1;
            this.m_stores += (long)data.size();
        }
        return retval;
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        return this.handlePutExternalAndKeyValue(ctx);
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handlePutExternalAndKeyValue(ctx);
    }

    private Object handlePutExternalAndKeyValue(InvocationContext ctx) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.nextInterceptor(ctx);
        long t2 = System.currentTimeMillis();
        this.m_store_times += t2 - t1;
        ++this.m_stores;
        return retval;
    }

    @Override
    public long getHits() {
        return this.m_hits;
    }

    @Override
    public long getMisses() {
        return this.m_misses;
    }

    @Override
    public long getStores() {
        return this.m_stores;
    }

    @Override
    public long getEvictions() {
        return this.m_evictions;
    }

    @Override
    public double getHitMissRatio() {
        double total = this.m_hits + this.m_misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.m_hits / total;
    }

    @Override
    public double getReadWriteRatio() {
        if (this.m_stores == 0L) {
            return 0.0;
        }
        return (double)(this.m_hits + this.m_misses) / (double)this.m_stores;
    }

    @Override
    public long getAverageReadTime() {
        long total = this.m_hits + this.m_misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.m_hit_times + this.m_miss_times) / total;
    }

    @Override
    public long getAverageWriteTime() {
        if (this.m_stores == 0L) {
            return 0L;
        }
        return this.m_store_times / this.m_stores;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.cache.getNumberOfAttributes();
    }

    @Override
    public int getNumberOfNodes() {
        return this.cache.getNumberOfNodes();
    }

    @Override
    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.m_start) / 1000L;
    }

    @Override
    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.m_reset) / 1000L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Hits", this.m_hits);
        retval.put("Misses", this.m_misses);
        retval.put("Stores", this.m_stores);
        retval.put("Evictions", this.m_evictions);
        retval.put("NumberOfAttributes", this.cache.getNumberOfAttributes());
        retval.put("NumberOfNodes", this.cache.getNumberOfNodes());
        retval.put("ElapsedTime", this.getElapsedTime());
        retval.put("TimeSinceReset", this.getTimeSinceReset());
        retval.put("AverageReadTime", this.getAverageReadTime());
        retval.put("AverageWriteTime", this.getAverageWriteTime());
        retval.put("HitMissRatio", this.getHitMissRatio());
        retval.put("ReadWriteRatio", this.getReadWriteRatio());
        return retval;
    }

    @Override
    public void resetStatistics() {
        this.m_hits = 0L;
        this.m_misses = 0L;
        this.m_stores = 0L;
        this.m_evictions = 0L;
        this.m_hit_times = 0L;
        this.m_miss_times = 0L;
        this.m_store_times = 0L;
        this.m_reset = System.currentTimeMillis();
    }
}

