/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.marshall.MethodCall;

public abstract class AbstractInvocationDelegate {
    protected Interceptor interceptorChain;
    protected CacheImpl cache;
    protected Log log = LogFactory.getLog(AbstractInvocationDelegate.class);
    protected Configuration configuration;
    protected boolean originLocal = true;
    protected InvocationContextContainer invocationContextContainer;

    @Inject
    private void initialise(Interceptor interceptorChain, CacheImpl cache, Configuration configuration, InvocationContextContainer invocationContextContainer) {
        this.interceptorChain = interceptorChain;
        this.cache = cache;
        this.configuration = configuration;
        this.invocationContextContainer = invocationContextContainer;
    }

    protected Object invoke(MethodCall call) throws CacheException {
        this.assertIsConstructed();
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        return this.invoke(call, ctx.getOptionOverrides().isSkipCacheStatusCheck(), ctx);
    }

    protected Object invoke(MethodCall call, boolean skipCacheStatusCheck) throws CacheException {
        this.assertIsConstructed();
        return this.invoke(call, skipCacheStatusCheck, (InvocationContext)this.invocationContextContainer.get());
    }

    private void assertIsConstructed() {
        if (this.invocationContextContainer == null) {
            throw new IllegalStateException("The cache has been destroyed!");
        }
    }

    private Object invoke(MethodCall call, boolean skipCacheStatusCheck, InvocationContext ctx) throws CacheException {
        if (!this.cache.getCacheStatus().allowInvocations() && !skipCacheStatusCheck) {
            if (this.originLocal) {
                throw new IllegalStateException("Cache not in STARTED state!");
            }
            if (this.cache.getCacheStatus() == CacheStatus.STARTING) {
                try {
                    this.blockUntilCacheStarts();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.log.warn((Object)"Received a remote call but the cache is not in STARTED state - ignoring call.");
                return null;
            }
        }
        MethodCall oldCall = null;
        try {
            oldCall = ctx.getMethodCall();
            ctx.setMethodCall(call);
            if (!this.originLocal) {
                ctx.setOriginLocal(false);
            }
            Object object = this.interceptorChain.invoke(ctx);
            return object;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            if (!this.originLocal) {
                ctx.setOriginLocal(true);
            }
            if (ctx == null) {
                ctx = (InvocationContext)this.invocationContextContainer.get();
            }
            ctx.setMethodCall(oldCall);
        }
    }

    private void blockUntilCacheStarts() throws InterruptedException, IllegalStateException {
        int pollFrequencyMS = 100;
        long startupWaitTime = this.configuration.getStateRetrievalTimeout();
        long giveUpTime = System.currentTimeMillis() + startupWaitTime;
        while (System.currentTimeMillis() < giveUpTime && !this.cache.getCacheStatus().allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
        if (!this.cache.getCacheStatus().allowInvocations()) {
            throw new IllegalStateException("Cache not in STARTED state, even after waiting " + this.configuration.getStateRetrievalTimeout() + " millis.");
        }
    }
}

