/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCacheInvocationDelegate
extends CacheInvocationDelegate {
    private BuddyManager buddyManager;

    public RemoteCacheInvocationDelegate() {
        this.originLocal = false;
        this.log = LogFactory.getLog(RemoteCacheInvocationDelegate.class);
    }

    @Inject
    private void injectBuddyManager(BuddyManager buddyManager) {
        this.buddyManager = buddyManager;
    }

    public void assignToBuddyGroup(BuddyGroup group, Map<Fqn, byte[]> state) throws Exception {
        if (this.buddyManager != null) {
            this.buddyManager.handleAssignToBuddyGroup(group, state);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received assignToBuddyGroup call from group owner [" + group.getDataOwner() + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void removeFromBuddyGroup(String groupName) throws BuddyNotInitException {
        if (this.buddyManager != null) {
            this.buddyManager.handleRemoveFromBuddyGroup(groupName);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received removeFromBuddyGroup call for group name [" + groupName + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void announceBuddyPoolName(Address address, String buddyPoolName) {
        if (this.buddyManager != null) {
            this.buddyManager.handlePoolNameBroadcast(address, buddyPoolName);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received annouceBuddyPoolName call from [" + address + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void dataGravitationCleanup(Fqn primary, Fqn backup) throws Exception {
        if (this.buddyManager.isDataGravitationRemoveOnFind()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("DataGravitationCleanup: Removing primary (" + primary + ") and backup (" + backup + ")"));
            }
            this.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            if (!this.removeNode(primary)) {
                this.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.removeNode(backup);
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("DataGravitationCleanup: Evicting primary (" + primary + ") and backup (" + backup + ")"));
            }
            this.evict(primary, true);
            this.evict(backup, true);
        }
    }

    public Object _replicate(MethodCall methodCall) throws Throwable {
        try {
            Object retVal = this.invoke(methodCall);
            if (MethodDeclarations.returnValueForRemoteCall(methodCall.getMethodId())) {
                return retVal;
            }
            return null;
        }
        catch (Throwable ex) {
            if (methodCall.getMethodId() != 45 || methodCall.getMethodId() != 46) {
                if (!MethodDeclarations.isBuddyGroupOrganisationMethod(methodCall.getMethodId()) && this.log.isWarnEnabled()) {
                    this.log.warn((Object)("replication failure with methodCall " + (Object)((Object)methodCall) + " exception"), ex);
                }
                throw ex;
            }
            return null;
        }
    }

    public void _replicate(List<MethodCall> methodCalls) throws Throwable {
        for (MethodCall methodCall : methodCalls) {
            this._replicate((MethodCall)((Object)methodCall.getArgs()[0]));
        }
    }

    public void block() {
        MethodCall m = MethodCallFactory.create(43, new Object[0]);
        this.invoke(m, true);
    }

    public void unblock() {
        MethodCall m = MethodCallFactory.create(44, new Object[0]);
        this.invoke(m, true);
    }

    public List clusteredGet(MethodCall methodCall, Boolean searchBackupSubtrees) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Clustered Get called with params: " + (Object)((Object)methodCall) + ", " + searchBackupSubtrees));
        }
        Method m = methodCall.getMethod();
        Object[] args = methodCall.getArgs();
        Object callResults = null;
        try {
            Fqn fqn = (Fqn)args[0];
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Clustered get: invoking call " + m + " with Fqn " + fqn));
            }
            callResults = m.invoke((Object)this.cache, args);
            boolean found = this.validResult(callResults, methodCall, fqn);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Got result " + callResults + ", found=" + found));
            }
            if (found && callResults == null) {
                callResults = this.createEmptyResults(methodCall);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Problems processing clusteredGet call", (Throwable)e);
        }
        ArrayList<Object> results = new ArrayList<Object>(2);
        if (callResults != null) {
            results.add(true);
            results.add(callResults);
        } else {
            results.add(false);
            results.add(null);
        }
        return results;
    }

    private boolean validResult(Object callResults, MethodCall mc, Fqn fqn) {
        switch (mc.getMethodId()) {
            case 23: 
            case 24: {
                return callResults != null || this.exists(fqn);
            }
            case 16: {
                return (Boolean)callResults;
            }
        }
        return false;
    }

    private Object createEmptyResults(MethodCall mc) {
        switch (mc.getMethodId()) {
            case 23: 
            case 24: {
                return Collections.emptyMap();
            }
        }
        return null;
    }
}

