/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoader;

public class JDBCCacheLoaderConfig
extends AdjListJDBCCacheLoaderConfig {
    private static final long serialVersionUID = -8371846151643130271L;
    private static final Log log = LogFactory.getLog(JDBCCacheLoaderConfig.class);
    private String deleteNode;
    private String recursiveChildren;
    private String nodeCountSql;

    public JDBCCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        super(base);
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public JDBCCacheLoaderConfig() {
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        String sqlConcat = props.getProperty("cache.jdbc.sql-concat");
        if (sqlConcat == null) {
            log.info((Object)"Missiing JDBCCacheLoader config 'cache.jdbc.sql-concat', using default value:'concat(1,2)'");
            sqlConcat = "concat(1,2)";
        }
        String startingWith = sqlConcat.replace('1', '?').replace("2", "'%'");
        String appendSepparator = sqlConcat.replace("1", this.fqnColumn).replace("2", "'/'");
        this.deleteNode = "delete from " + this.table + " where " + appendSepparator + " like " + startingWith;
        this.recursiveChildren = "select " + this.fqnColumn + "," + this.nodeColumn + " from " + this.table + " where " + appendSepparator + " like " + startingWith;
        this.nodeCountSql = "select count(*) from " + this.table;
    }

    public String getDeleteNodeSql() {
        return this.deleteNode;
    }

    public String getRecursiveChildrenSql() {
        return this.recursiveChildren;
    }

    public String getNodeCountSql() {
        return this.nodeCountSql;
    }
}

