/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javabean.plugins.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.javabean.plugins.xml.Common;
import org.jboss.javabean.plugins.xml.ConfigurationUtil;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class JavaBeanSchemaInitializer
implements SchemaBindingInitializer {
    private static final String JAVABEAN_NS = "urn:jboss:javabean:1.0";
    private static final QName javabeanTypeQName = new QName("urn:jboss:javabean:1.0", "javabeanType");
    private static final QName propertyTypeQName = new QName("urn:jboss:javabean:1.0", "propertyType");
    private static final QName propertyQName = new QName("urn:jboss:javabean:1.0", "property");

    public SchemaBinding init(SchemaBinding schema) {
        schema.setReplacePropertyRefs(false);
        TypeBinding beanType = schema.getType(javabeanTypeQName);
        beanType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new Common.Holder();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                Common.Holder holder = (Common.Holder)o;
                String className = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if (!"class".equals(localName)) continue;
                    className = attrs.getValue(i);
                }
                if (className == null) {
                    throw new IllegalArgumentException("No class attribute for " + elementName);
                }
                try {
                    BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(className);
                    Object object = beanInfo.newInstance();
                    holder.setValue(object);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error instantiating class " + className, t);
                }
            }

            public Object endElement(Object o, QName qName, ElementBinding element) {
                Common.Holder holder = (Common.Holder)o;
                return holder.getValue();
            }
        });
        beanType.pushInterceptor(propertyQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName name) {
                Common.Holder holder = (Common.Holder)parent;
                Object parentValue = holder.getValue();
                Common.Property prop = (Common.Property)child;
                String property = prop.getProperty();
                Object value = prop.getValue();
                try {
                    BeanInfo info = ConfigurationUtil.getBeanInfo(parentValue.getClass());
                    value = ConfigurationUtil.convertValue(parentValue, property, prop.getType(), value);
                    info.setProperty(parentValue, property, value);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error setting property " + property + " on object" + parentValue + " with value " + value, t);
                }
            }
        });
        TypeBinding propertyType = schema.getType(propertyTypeQName);
        propertyType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new Common.Property();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                Common.Property property = (Common.Property)o;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if ("name".equals(localName)) {
                        property.setProperty(attrs.getValue(i));
                        continue;
                    }
                    if (!"class".equals(localName)) continue;
                    property.setType(attrs.getValue(i));
                }
            }
        });
        return schema;
    }

    static {
        ConfigurationUtil.init();
    }
}

