/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javabean.plugins.xml;

import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.javabean.plugins.xml.Common;
import org.jboss.javabean.plugins.xml.ConfigurationUtil;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;

public class PropertyInterceptor
extends DefaultElementInterceptor {
    public static final PropertyInterceptor INTERCEPTOR = new PropertyInterceptor();

    public void add(Object parent, Object child, QName name) {
        Common.Holder holder = (Common.Holder)parent;
        Object parentValue = holder.getValue();
        Common.Property prop = (Common.Property)child;
        Object value = prop.getValue();
        String property = prop.getProperty();
        try {
            if (parentValue instanceof Common.Ctor) {
                Common.Ctor ctor = (Common.Ctor)parentValue;
                if (ctor.isCtorWasDeclared()) {
                    BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(ctor.getClassName());
                    PropertyInfo propertyInfo = beanInfo.getProperty(property);
                    value = ConfigurationUtil.convertValue(propertyInfo, prop.getType(), value);
                    ctor.addParam(propertyInfo.getType().getName(), value);
                } else {
                    parentValue = ctor.newInstance();
                    holder.setValue(parentValue);
                    this.add(parent, child, name);
                }
            } else {
                BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(parentValue);
                value = ConfigurationUtil.convertValue(parentValue, property, prop.getType(), value);
                beanInfo.setProperty(parentValue, property, value);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error setting property " + property + " on object" + parentValue + " with value " + value, t);
        }
    }
}

