/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Method;
import org.jboss.metadata.spi.signature.Signature;

public class MethodParametersSignature
extends Signature {
    private int param;

    public MethodParametersSignature(String name, String[] parameters, int param) {
        super(name, parameters);
        this.param = param;
        this.checkParam();
    }

    public MethodParametersSignature(String name, int param, Class ... parameters) {
        super(name, parameters);
        this.param = param;
        this.checkParam();
    }

    public MethodParametersSignature(Method method, int param) {
        super(method.getName(), (Class[])method.getParameterTypes());
        this.param = param;
        this.checkParam();
    }

    public int getParam() {
        return this.param;
    }

    protected void checkParam() {
        if (this.param < 0 || this.param >= this.getParameters().length) {
            throw new IllegalArgumentException("param must be between 0 and " + this.getParameters().length);
        }
    }

    protected void internalToString(StringBuilder builder) {
        super.internalToString(builder);
        builder.append("#").append(this.param);
    }
}

