/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class GetKeysTest {
    CacheSPI<Object, Object> cache;

    @Test(groups={"functional"})
    public void testGetKeys() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
        this.cache.put("/a/b/c", (Object)"name", (Object)"Bela Ban");
        this.cache.put("/a/b/c", (Object)"age", (Object)40);
        this.cache.put("/a/b/c", (Object)"city", (Object)"Kreuzlingen");
        Set keys = this.cache.getNode("/a/b/c").getKeys();
        this.log("keys are " + keys);
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(20);
        ObjectOutputStream out = new ObjectOutputStream(outstream);
        out.writeObject(keys);
    }

    @Test(groups={"functional"})
    public void testGetChildren() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        Set children = this.cache.getNode("/a/b/c").getChildrenNames();
        this.log("children are " + children);
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(20);
        ObjectOutputStream out = new ObjectOutputStream(outstream);
        out.writeObject(children);
    }

    @Test(groups={"functional"})
    public void testGetKeysOnNode() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        Node node = this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b/c"));
        Set keySet = node.getKeys();
        try {
            keySet.add("asd");
            AssertJUnit.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }
}

