/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import java.util.Collections;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotValidException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class NodeValidityTestBase {
    protected boolean optimistic;
    protected boolean clustered = true;
    protected boolean invalidation = false;
    protected Cache<String, String> observer;
    protected Cache<String, String> modifier;
    protected Fqn parent = Fqn.fromString((String)"/parent");
    protected Fqn child = Fqn.fromString((String)"/parent/child");
    protected String K = "k";
    protected String V = "v";

    protected abstract Cache<String, String> createObserver();

    protected abstract Cache<String, String> createModifier();

    protected void optimisticConfiguration(Configuration c) {
        if (this.optimistic) {
            c.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
            c.setSyncCommitPhase(true);
            c.setSyncRollbackPhase(true);
        }
    }

    @BeforeMethod
    public void setUp() {
        this.observer = this.createObserver();
        this.modifier = this.createModifier();
        if (this.clustered) {
            TestingUtil.blockUntilViewsReceived(60000L, this.observer, this.modifier);
        }
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.observer, this.modifier);
        this.observer = null;
        this.modifier = null;
    }

    public void testRemoval() {
        this.observer.put(this.parent, (Object)this.K, (Object)this.V);
        Node obsNode = this.observer.getRoot().getChild(this.parent);
        assert (((String)obsNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        this.modifier.removeNode(this.parent);
        assert (!obsNode.isValid()) : "Should no longer be valid";
    }

    public void testRemovalWithChildren() {
        this.observer.put(this.child, (Object)this.K, (Object)this.V);
        Node obsParentNode = this.observer.getRoot().getChild(this.parent);
        Node obsChildNode = this.observer.getRoot().getChild(this.child);
        assert (((String)obsChildNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsChildNode.isValid()) : "Node should be valid";
        assert (obsParentNode.isValid()) : "Node should be valid";
        this.modifier.removeNode(this.parent);
        assert (!obsParentNode.isValid()) : "Should no longer be valid";
        assert (!obsChildNode.isValid()) : "Should no longer be valid";
    }

    public void testMove() {
        Fqn newParent = Fqn.fromString((String)"/newParent/parent");
        this.observer.put(this.parent, (Object)this.K, (Object)this.V);
        Node obsNode = this.observer.getRoot().getChild(this.parent);
        assert (((String)obsNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        this.modifier.getRoot().addChild(newParent);
        this.modifier.move(this.parent, newParent.getParent());
        if (this.optimistic) assert (!obsNode.isValid()) : "Should no longer be valid";
        assert (this.observer.getRoot().getChild(newParent).isValid()) : "Should be valid";
    }

    public void testMoveWithChildren() {
        Fqn newParent = Fqn.fromString((String)"/newParent/parent");
        Fqn newChild = Fqn.fromString((String)"/newParent/parent/child");
        this.observer.put(this.child, (Object)this.K, (Object)this.V);
        Node obsParentNode = this.observer.getRoot().getChild(this.parent);
        Node obsChildNode = this.observer.getRoot().getChild(this.child);
        assert (((String)obsChildNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsChildNode.isValid()) : "Node should be valid";
        assert (obsParentNode.isValid()) : "Node should be valid";
        this.modifier.getRoot().addChild(newParent);
        this.modifier.move(this.parent, newParent.getParent());
        if (this.optimistic) {
            assert (!obsParentNode.isValid()) : "Should no longer be valid";
            assert (!obsChildNode.isValid()) : "Should no longer be valid";
        }
        assert (this.observer.getRoot().getChild(newParent).isValid()) : "Should be valid";
        assert (this.observer.getRoot().getChild(newChild).isValid()) : "Should be valid";
    }

    public void testEvict() {
        this.observer.put(this.parent, (Object)this.K, (Object)this.V);
        Node obsNode = this.observer.getRoot().getChild(this.parent);
        assert (((String)obsNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        this.observer.evict(this.parent, false);
        assert (obsNode.isValid()) : "Node should be valid";
    }

    public void testOperationsOnInvalidNode() {
        this.observer.put(this.parent, (Object)this.K, (Object)this.V);
        Node obsNode = this.observer.getRoot().getChild(this.parent);
        assert (((String)obsNode.get((Object)this.K)).equals(this.V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        this.modifier.removeNode(this.parent);
        assert (!obsNode.isValid()) : "Node should not be valid";
        try {
            obsNode.get((Object)this.K);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.put((Object)this.K, (Object)"v2");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.remove((Object)this.K);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.clearData();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.putAll(Collections.singletonMap(this.K, "v2"));
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.getKeys();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.hasChild((Object)"Something");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.removeChild((Object)"Something");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.addChild(this.child);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.getChildrenNames();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException nodeNotValidException) {
            // empty catch block
        }
    }

    public void testExistenceOfTombstones() {
        CacheSPI modifierImpl = (CacheSPI)this.modifier;
        CacheSPI observerImpl = (CacheSPI)this.observer;
        this.modifier.put(this.parent, (Object)this.K, (Object)this.V);
        this.modifier.removeNode(this.parent);
        if (this.optimistic && this.invalidation) {
            NodeSPI modifierTombstone = modifierImpl.peek(this.parent, true, true);
            NodeSPI observerTombstone = observerImpl.peek(this.parent, true, true);
            assert (modifierTombstone != null) : "Modifier tombstone should not be null";
            assert (observerTombstone != null) : "Observer tombstone should not be null";
            assert (!modifierTombstone.isValid()) : "Should not be valid";
            assert (!observerTombstone.isValid()) : "Should not be valid";
            assert (((DefaultDataVersion)modifierTombstone.getVersion()).getRawVersion() == 2L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerTombstone.getVersion()).getRawVersion() == 2L) : "Tombstone should be versioned";
        } else {
            assert (modifierImpl.peek(this.parent, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(this.parent, true, true) == null) : "Tombstone should not exist";
        }
    }

    public void testExistenceOfTombstonesWithChildren() {
        CacheSPI modifierImpl = (CacheSPI)this.modifier;
        CacheSPI observerImpl = (CacheSPI)this.observer;
        this.modifier.put(this.child, (Object)this.K, (Object)this.V);
        this.modifier.removeNode(this.parent);
        if (this.optimistic && this.invalidation) {
            NodeSPI modifierParentTombstone = modifierImpl.peek(this.parent, true, true);
            NodeSPI observerParentTombstone = observerImpl.peek(this.parent, true, true);
            NodeSPI modifierChildTombstone = modifierImpl.peek(this.child, true, true);
            NodeSPI observerChildTombstone = observerImpl.peek(this.child, true, true);
            assert (modifierParentTombstone != null) : "Modifier parent tombstone should not be null";
            assert (observerParentTombstone != null) : "Observer parent tombstone should not be null";
            assert (modifierChildTombstone != null) : "Modifier child tombstone should not be null";
            assert (observerChildTombstone != null) : "Observer child tombstone should not be null";
            assert (!modifierParentTombstone.isValid()) : "Should not be valid";
            assert (!observerParentTombstone.isValid()) : "Should not be valid";
            assert (!modifierChildTombstone.isValid()) : "Should not be valid";
            assert (!observerChildTombstone.isValid()) : "Should not be valid";
            assert (((DefaultDataVersion)modifierParentTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerParentTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)modifierChildTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerChildTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
        } else {
            assert (modifierImpl.peek(this.parent, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(this.parent, true, true) == null) : "Tombstone should not exist";
            assert (modifierImpl.peek(this.child, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(this.child, true, true) == null) : "Tombstone should not exist";
        }
    }
}

