/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class BuddyAssignmentStateTransferTest
extends BuddyReplicationTestsBase {
    protected int timeout = 10000;

    protected int getSleepTimeout() {
        return this.timeout;
    }

    public void testNonRegionBasedStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCache(1, "TEST", false, true));
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        this.caches.add(this.createCache(1, "TEST", false, true));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn test = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress())});
        test = new Fqn(test, main);
        AssertJUnit.assertEquals((String)"State transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(test, (Object)"name"));
        this.caches.add(this.createCache(1, "TEST", false, true));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertNull((String)"State not transferred", (Object)((CacheSPI)this.caches.get(2)).get(test, (Object)"name"));
        ((CacheSPI)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertEquals((String)"State transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(test, (Object)"name"));
    }

    public void testRegionBasedStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        ((CacheSPI)this.caches.get(0)).getConfiguration().setInactiveOnStartup(true);
        ((CacheSPI)this.caches.get(1)).getConfiguration().setInactiveOnStartup(true);
        ((CacheSPI)this.caches.get(2)).getConfiguration().setInactiveOnStartup(true);
        ((CacheSPI)this.caches.get(3)).getConfiguration().setInactiveOnStartup(true);
        ((CacheSPI)this.caches.get(0)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheSPI)this.caches.get(1)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheSPI)this.caches.get(2)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheSPI)this.caches.get(3)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheSPI)this.caches.get(0)).start();
        ((CacheSPI)this.caches.get(1)).start();
        ((CacheSPI)this.caches.get(2)).start();
        ((CacheSPI)this.caches.get(3)).start();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn fqnA = Fqn.fromString((String)"/a");
        Fqn fqnD = Fqn.fromString((String)"/d");
        ClassLoader cl = Fqn.class.getClassLoader();
        ((CacheSPI)this.caches.get(0)).getRegion(fqnA, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(1)).getRegion(fqnA, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(2)).getRegion(fqnA, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(3)).getRegion(fqnA, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(0)).getRegion(fqnD, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(1)).getRegion(fqnD, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(2)).getRegion(fqnD, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(3)).getRegion(fqnD, true).registerContextClassLoader(cl);
        ((CacheSPI)this.caches.get(0)).getRegion(fqnA, true).activate();
        ((CacheSPI)this.caches.get(1)).getRegion(fqnA, true).activate();
        ((CacheSPI)this.caches.get(2)).getRegion(fqnA, true).activate();
        ((CacheSPI)this.caches.get(3)).getRegion(fqnA, true).activate();
        ((CacheSPI)this.caches.get(0)).getRegion(fqnD, true).activate();
        ((CacheSPI)this.caches.get(1)).getRegion(fqnD, true).activate();
        Fqn mainA = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(mainA, (Object)"name", (Object)"Joe");
        Fqn mainD = Fqn.fromString((String)"/d/e/f");
        ((CacheSPI)this.caches.get(0)).put(mainD, (Object)"name", (Object)"Joe");
        Fqn group = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, new Object[]{BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress())});
        Fqn testA = new Fqn(group, mainA);
        AssertJUnit.assertEquals((String)"/a replicated", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(testA, (Object)"name"));
        AssertJUnit.assertNull((String)"No backup of /a", (Object)((CacheSPI)this.caches.get(2)).get(testA, (Object)"name"));
        Fqn testD = new Fqn(group, mainD);
        AssertJUnit.assertEquals((String)"/d replicated", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(testD, (Object)"name"));
        AssertJUnit.assertNull((String)"No backup of /d", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        ((CacheSPI)this.caches.get(1)).stop();
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertEquals((String)"/a state transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(testA, (Object)"name"));
        AssertJUnit.assertNull((String)"/d state not transferred", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        ((CacheSPI)this.caches.get(2)).getRegion(fqnD, true).activate();
        ((CacheSPI)this.caches.get(3)).getRegion(fqnD, true).activate();
        AssertJUnit.assertEquals((String)"/d transferred to cache 2", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        AssertJUnit.assertNull((String)"/d state not transferred to cache 3", (Object)((CacheSPI)this.caches.get(3)).get(testD, (Object)"name"));
    }

    public void testPersistentStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheSPI)this.caches.get(0)).getConfiguration().setFetchInMemoryState(false);
        ((CacheSPI)this.caches.get(0)).start();
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheSPI)this.caches.get(1)).getConfiguration().setFetchInMemoryState(false);
        ((CacheSPI)this.caches.get(1)).start();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn test = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(0)).getLocalAddress(), (Fqn)main);
        AssertJUnit.assertFalse((String)"/a/b/c shld not be bin memory", (boolean)((CacheSPI)this.caches.get(1)).exists(test));
        AssertJUnit.assertNotNull((String)"/a/b/c shld be in CL", (Object)((CacheSPI)this.caches.get(1)).getCacheLoaderManager().getCacheLoader().get(test));
        AssertJUnit.assertEquals((String)"/a/b/c shld in cache loader", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(test, (Object)"name"));
    }
}

