/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.ExpirationConfiguration;
import org.jboss.cache.eviction.ExpirationPolicy;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ExpirationPolicyTest {
    private static final Log log = LogFactory.getLog(ExpirationPolicyTest.class);
    private CacheSPI<Object, Object> cache;
    Fqn fqn1 = Fqn.fromString((String)"/node/1");
    Fqn fqn2 = Fqn.fromString((String)"/node/2");
    Fqn fqn3 = Fqn.fromString((String)"/node/3");
    Fqn fqn4 = Fqn.fromString((String)"/node/4");
    Long future;
    Long past;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        EvictionConfig econf = new EvictionConfig(ExpirationPolicy.class.getName());
        econf.setWakeupIntervalSeconds(1);
        conf.setEvictionConfig(econf);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(conf, false);
        this.cache.start();
        this.future = System.currentTimeMillis() + 4000L;
        this.past = System.currentTimeMillis() - 2000L;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testEviction() throws Exception {
        this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn2, (Object)"expiration", (Object)this.past);
        this.cache.put(this.fqn3, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn4, (Object)"foo", (Object)"bar");
        TestingUtil.sleepThread(2000L);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn2));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn3));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn4));
        log.info((Object)"should remove 1 and 3 now");
        TestingUtil.sleepThread(3000L);
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn3));
    }

    public void testUpdate() throws Exception {
        log.info((Object)"update 1 from future to past");
        this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        TestingUtil.sleepThread(1500L);
        this.cache.put(this.fqn1, (Object)"expiration", (Object)this.past);
        TestingUtil.sleepThread(1500L);
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
        this.cache.removeNode(Fqn.ROOT);
    }

    public void testUpdateToFuture() throws Exception {
        log.info((Object)"update 1 from future to past");
        Long future2 = this.future + 2000L;
        this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
        TestingUtil.sleepThread(2000L);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        this.cache.put(this.fqn1, (Object)"expiration", (Object)future2);
        TestingUtil.sleepThread(3000L);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        TestingUtil.sleepThread(3000L);
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
        this.cache.removeNode(Fqn.ROOT);
    }

    public void testMaxNodes() throws Exception {
        log.info((Object)"set max nodes to 2, expire soonest to expire first");
        EvictionPolicyConfig epc = ((Region)this.cache.getRegionManager().getAllRegions(Region.Type.EVICTION).get(0)).getEvictionPolicyConfig();
        ExpirationConfiguration ec = (ExpirationConfiguration)epc;
        ec.setMaxNodes(2);
        Long future2 = this.future + 500L;
        this.cache.put(this.fqn1, (Object)"expiration", (Object)future2);
        this.cache.put(this.fqn2, (Object)"expiration", (Object)future2);
        this.cache.put(this.fqn3, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn4, (Object)"expiration", (Object)this.past);
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfNodes());
        Thread.sleep(2000L);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn2));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn3));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn4));
    }
}

