/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.NullEvictionPolicyConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NullEvictionPolicyTest {
    CacheSPI<Object, Object> cache_;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache_ = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache_ != null) {
            this.cache_.stop();
            this.cache_.destroy();
        }
    }

    public void testEviction() {
        Fqn lru;
        Fqn test;
        Fqn dflt;
        int i;
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = config.getEvictionConfig();
        evConfig.setWakeupIntervalSeconds(1);
        evConfig.setDefaultEventQueueSize(200000);
        evConfig.setDefaultEvictionPolicyClass("org.jboss.cache.eviction.NullEvictionPolicy");
        ArrayList<EvictionRegionConfig> regionConfigs = new ArrayList<EvictionRegionConfig>();
        regionConfigs.add(this.buildEvictionRegionConfig("/_default_"));
        regionConfigs.add(this.buildEvictionRegionConfig("/test"));
        regionConfigs.add(UnitTestCacheConfigurationFactory.buildLruEvictionRegionConfig("/lru", 10000, 1));
        evConfig.setEvictionRegionConfigs(regionConfigs);
        config.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache_ = (CacheSPI)new DefaultCacheFactory().createCache(config);
        String dfltRootStr = "/a/";
        String testRootStr = "/test/";
        String lruRootStr = "/lru/";
        for (i = 0; i < 20; ++i) {
            dflt = Fqn.fromString((String)(dfltRootStr + i));
            test = Fqn.fromString((String)(testRootStr + i));
            lru = Fqn.fromString((String)(lruRootStr + i));
            this.cache_.put(dflt, (Object)"key", (Object)"value");
            this.cache_.put(test, (Object)"key", (Object)"value");
            this.cache_.put(lru, (Object)"key", (Object)"value");
        }
        TestingUtil.sleepThread(3500L);
        for (i = 0; i < 20; ++i) {
            dflt = Fqn.fromString((String)(dfltRootStr + i));
            test = Fqn.fromString((String)(testRootStr + i));
            lru = Fqn.fromString((String)(lruRootStr + i));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(dflt, (Object)"key"));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(test, (Object)"key"));
            AssertJUnit.assertNull((Object)this.cache_.get(lru, (Object)"key"));
        }
    }

    private EvictionRegionConfig buildEvictionRegionConfig(String regionName) {
        EvictionRegionConfig evRegConfig = new EvictionRegionConfig();
        evRegConfig.setRegionName(regionName);
        NullEvictionPolicyConfig nullEvictionPolicyConfig = new NullEvictionPolicyConfig();
        evRegConfig.setEvictionPolicyConfig((EvictionPolicyConfig)nullEvictionPolicyConfig);
        return evRegConfig;
    }
}

