/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DataSourceIntegrationTest
extends AbstractCacheLoaderTestBase {
    private String old_factory = null;
    private final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    private final String JNDI_NAME = "java:/MockDS";
    private CacheSPI cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.old_factory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        DummyTransactionManager.getInstance();
    }

    protected CacheLoaderConfig getCacheLoaderConfig(String jndi) throws Exception {
        String props = "cache.jdbc.datasource=" + jndi + "\ncache.jdbc.table.create=true\ncache.jdbc.table.drop=true";
        CacheLoaderConfig cacheLoaderConfig = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, false, false);
        return cacheLoaderConfig;
    }

    public void testDataSourceIntegration() throws Exception {
        InitialContext context = new InitialContext();
        try {
            Object obj = context.lookup("java:/MockDS");
            AssertJUnit.assertNull((String)"java:/MockDS not bound", (Object)obj);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig("java:/MockDS"));
        this.cache.create();
        context.bind("java:/MockDS", (Object)new MockDataSource());
        AssertJUnit.assertNotNull((String)"java:/MockDS bound", (Object)context.lookup("java:/MockDS"));
        this.cache.start();
        AssertJUnit.assertNotNull((String)"Cache has a cache loader", (Object)this.cache.getCacheLoaderManager().getCacheLoader());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind("java:/MockDS");
        if (this.old_factory != null) {
            System.setProperty("java.naming.factory.initial", this.old_factory);
        } else {
            System.getProperties().remove("java.naming.factory.initial");
        }
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockDataSource
    implements DataSource {
        private String userName;
        private String jdbcUrl;
        private String jdbcPassword;

        public MockDataSource() {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
                Class.forName(properties.getProperty("cache.jdbc.driver"));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading jdbc properties ", e);
            }
            this.userName = properties.getProperty("cache.jdbc.user");
            this.jdbcUrl = properties.getProperty("cache.jdbc.url");
            this.jdbcPassword = properties.getProperty("cache.jdbc.password");
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.jdbcUrl, this.userName, this.jdbcPassword);
        }

        @Override
        public Connection getConnection(String user, String password) throws SQLException {
            return DriverManager.getConnection(this.jdbcUrl, this.userName, this.jdbcPassword);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> ifc) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }
    }
}

