/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.marshall.AbstractVersionAwareMarshallerTest;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheMarshallerTestBase
extends AbstractVersionAwareMarshallerTest {
    protected String currentVersion;
    protected int currentVersionShort;
    protected Class expectedMarshallerClass;
    protected Class latestMarshallerClass = CacheMarshaller210.class;
    protected VersionAwareMarshaller marshaller;
    protected RegionManager regionManager;
    protected Configuration c;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManager();
        this.c = new Configuration();
        this.c.setUseRegionBasedMarshalling(false);
        this.c.setInactiveOnStartup(false);
        this.c.setReplVersionString(this.currentVersion);
        this.cr = new ComponentRegistry(this.c);
        this.marshaller = this.createVAMandRestartCache(this.regionManager);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.marshaller = null;
    }

    protected void assertMethodCallsEquals(MethodCall call1, MethodCall call2) {
        if (call1 == call2) {
            return;
        }
        AssertJUnit.assertEquals((String)"Method IDs should match", (int)call1.getMethodId(), (int)call2.getMethodId());
        AssertJUnit.assertEquals((String)"Method names should match", (String)call1.getName(), (String)call2.getName());
        AssertJUnit.assertEquals((String)"Method reflection objects should match", (Object)call1.getMethod(), (Object)call2.getMethod());
        if (call1.getArgs() == null || call2.getArgs() == null) {
            AssertJUnit.assertNull((String)"Both args should be null", (Object)call1.getArgs());
            AssertJUnit.assertNull((String)"Both args should be null", (Object)call2.getArgs());
        } else {
            Object[] call1Args = call1.getArgs();
            Object[] call2Args = call2.getArgs();
            this.assertObjectArraysAreEqual(call1Args, call2Args);
        }
    }

    protected void assertObjectArraysAreEqual(Object[] a1, Object[] a2) {
        AssertJUnit.assertEquals((String)"Number of args should match", (int)a1.length, (int)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] instanceof MethodCall && a2[i] instanceof MethodCall) {
                this.assertMethodCallsEquals((MethodCall)a1[i], (MethodCall)a2[i]);
                continue;
            }
            if (a1[i] instanceof List && a2[i] instanceof List) {
                Object[] a1Elements = ((List)a1[i]).toArray();
                Object[] a2Elements = ((List)a2[i]).toArray();
                this.assertObjectArraysAreEqual(a1Elements, a2Elements);
                continue;
            }
            AssertJUnit.assertEquals((String)("Argument # " + i + " should be equal"), (Object)a1[i], (Object)a2[i]);
        }
    }

    public void testGetMarshaller() {
        AssertJUnit.assertEquals((String)"Only one marshaller should be in the map by this stage", (int)1, (int)this.marshaller.marshallers.size());
        AssertJUnit.assertEquals((Object)this.expectedMarshallerClass, this.marshaller.getMarshaller(this.currentVersionShort).getClass());
        assert (this.marshaller.defaultMarshaller.getClass().equals(this.expectedMarshallerClass));
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(15).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(-1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(0).getClass());
        AssertJUnit.assertEquals(CacheMarshaller200.class, this.marshaller.getMarshaller(20).getClass());
        assert (this.marshaller.marshallers.size() == 2) : "Should have 2 marshallers now";
    }

    public void testStringBasedFqn() throws Exception {
        Fqn fqn = new Fqn(new Object[]{"JSESSIONID", "1010.10.5:3000", "1234567890", "1"});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)fqn);
        System.out.println("Marshalled to " + asBytes.length + " bytes");
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testNonStringBasedFqn() throws Exception {
        Fqn fqn = new Fqn(new Object[]{3, false});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)fqn);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testMethodCall() throws Exception {
        Fqn fqn = new Fqn(new Object[]{3, false});
        MethodCall call = MethodCallFactory.create((int)3, (Object[])new Object[]{fqn, "key", "value", true});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)call);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof MethodCall));
        MethodCall m2 = (MethodCall)o2;
        this.assertMethodCallsEquals(call, m2);
    }

    public void testNestedMethodCall() throws Exception {
        Fqn fqn = new Fqn(new Object[]{3, false});
        MethodCall call = MethodCallFactory.create((int)3, (Object[])new Object[]{fqn, "key", "value", true});
        MethodCall replicateCall = MethodCallFactory.create((int)13, (Object[])new Object[]{call});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)replicateCall);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof MethodCall));
        MethodCall m2 = (MethodCall)o2;
        this.assertMethodCallsEquals(replicateCall, m2);
    }

    public void testLargeString() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, false);
    }

    public void testLargerString() throws Exception {
        this.doLargeStringTest(32768, false);
    }

    public void test64KString() throws Exception {
        this.doLargeStringTest(65526, false);
        this.doLargeStringTest(65546, false);
    }

    public void test128KString() throws Exception {
        this.doLargeStringTest(131062, false);
        this.doLargeStringTest(131082, false);
    }

    public void testLargeStringMultiByte() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, true);
    }

    public void testLargerStringMultiByte() throws Exception {
        this.doLargeStringTest(32768, true);
    }

    public void test64KStringMultiByte() throws Exception {
        this.doLargeStringTest(65526, true);
        this.doLargeStringTest(65546, true);
    }

    public void test128KStringMultiByte() throws Exception {
        this.doLargeStringTest(131062, true);
        this.doLargeStringTest(131082, true);
    }

    protected void doLargeStringTest(int stringSize, boolean multiByteChars) throws Exception {
        StringBuilder sb = new StringBuilder();
        int startingChar = multiByteChars ? 210 : 65;
        for (int i = 0; i < stringSize; ++i) {
            sb.append((char)(startingChar + i % 26));
        }
        String largeString = sb.toString();
        AssertJUnit.assertEquals((int)stringSize, (int)largeString.length());
        byte[] buf = this.marshaller.objectToByteBuffer((Object)largeString);
        AssertJUnit.assertEquals((Object)largeString, (Object)this.marshaller.objectFromByteBuffer(buf));
    }

    public void testReplicationQueue() throws Exception {
        this.doReplicationQueueTest();
    }

    public void testReplicationQueueWithRegionBasedMarshalling() throws Exception {
        this.c.setUseRegionBasedMarshalling(true);
        this.marshaller.init();
        this.doReplicationQueueTest();
    }

    protected void doReplicationQueueTest() throws Exception {
        ArrayList<MethodCall> calls = new ArrayList<MethodCall>();
        Fqn f = new Fqn(new Object[]{"BlahBlah", 3, false});
        String k = "key";
        String v = "value";
        MethodCall actualCall = MethodCallFactory.create((int)3, (Object[])new Object[]{null, f, k, v, true});
        MethodCall replicateCall = MethodCallFactory.create((int)13, (Object[])new Object[]{actualCall});
        calls.add(replicateCall);
        actualCall = MethodCallFactory.create((int)3, (Object[])new Object[]{null, f, k, v, true});
        replicateCall = MethodCallFactory.create((int)13, (Object[])new Object[]{actualCall});
        calls.add(replicateCall);
        MethodCall call = MethodCallFactory.create((int)14, (Object[])new Object[]{calls});
        byte[] buf = this.marshaller.objectToByteBuffer((Object)call);
        this.assertMethodCallsEquals(call, (MethodCall)this.marshaller.objectFromByteBuffer(buf));
    }
}

