/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedClassnameClassLoader
extends ClassLoader {
    private String[] includedClasses = null;
    private String[] excludedClasses = null;
    private String[] notFoundClasses = null;
    private Log log = LogFactory.getLog(SelectedClassnameClassLoader.class);
    private Map<String, Class> classes = new HashMap<String, Class>();

    public SelectedClassnameClassLoader(String[] includedClasses, String[] excludedClasses, ClassLoader parent) {
        super(parent);
        this.includedClasses = includedClasses;
        this.excludedClasses = excludedClasses;
    }

    public SelectedClassnameClassLoader(String[] includedClasses, String[] excludedClasses, String[] notFoundClasses, ClassLoader parent) {
        super(parent);
        this.includedClasses = includedClasses;
        this.excludedClasses = excludedClasses;
        this.notFoundClasses = notFoundClasses;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.log.info((Object)("In SelectedClassnameClassLoader.loadClass(" + name + "," + resolve + ")"));
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            Class<?> c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.log.info((Object)"In SelectedClassnameClassLoader.findClass()");
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            try {
                int read;
                InputStream is = this.getResourceAsStream(name.replace('.', '/').concat(".class"));
                byte[] bytes = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                while ((read = is.read(bytes)) > -1) {
                    baos.write(bytes, 0, read);
                }
                bytes = baos.toByteArray();
                result = this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (FileNotFoundException e) {
                throw new ClassNotFoundException("cannot find " + name, e);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("cannot read " + name, e);
            }
        } else {
            if (this.isNotFound(name)) {
                throw new ClassNotFoundException(name + " is discarded");
            }
            result = super.findClass(name);
        }
        this.classes.put(name, result);
        return result;
    }

    private boolean isIncluded(String className) {
        if (this.includedClasses != null) {
            for (int i = 0; i < this.includedClasses.length; ++i) {
                if (!className.startsWith(this.includedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcluded(String className) {
        if (this.excludedClasses != null) {
            for (int i = 0; i < this.excludedClasses.length; ++i) {
                if (!className.startsWith(this.excludedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotFound(String className) {
        if (this.notFoundClasses != null) {
            for (int i = 0; i < this.notFoundClasses.length; ++i) {
                if (!className.startsWith(this.notFoundClasses[i])) continue;
                return true;
            }
        }
        return false;
    }
}

