/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.Address;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class AbstractOptimisticTestCase {
    protected Fqn<String> fqn = Fqn.fromString((String)"/blah");
    protected String key = "myKey";
    protected String value = "myValue";
    protected Random random;

    protected CacheSPI<Object, Object> createCacheUnstarted() throws Exception {
        return this.createCacheUnstarted(true);
    }

    protected CacheSPI<Object, Object> createCacheUnstarted(boolean optimistic) throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL), false);
        if (optimistic) {
            cache.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        }
        return cache;
    }

    protected CacheSPI<Object, Object> createCacheWithListener() throws Exception {
        return this.createCacheWithListener(new TestListener());
    }

    protected CacheSPI<Object, Object> createCacheWithListener(Object listener) throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheUnstarted();
        cache.create();
        cache.start();
        cache.getNotifier().addCacheListener(listener);
        return cache;
    }

    protected CacheSPI<Object, Object> createCacheWithLoader() throws Exception {
        return this.createCacheWithLoader(false);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(boolean shared, boolean passivation) throws Exception {
        String xml = "            <config>\n                <passivation>" + passivation + "</passivation>\n" + "                <preload></preload>\n" + "                <shared>" + shared + "</shared>\n" + "                <cacheloader>\n" + "                    <class>" + (shared ? DummySharedInMemoryCacheLoader.class.getName() : DummyInMemoryCacheLoader.class.getName()) + "</class>\n" + "                    <properties>\n" + "                    </properties>\n" + "                    <async>false</async>\n" + "                    <fetchPersistentState>" + !shared + "</fetchPersistentState>\n" + "                    <ignoreModifications>false</ignoreModifications>\n" + "                </cacheloader>\n" + "            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    protected CacheSPI<Object, Object> createCacheWithLoader(boolean passivationEnabled) throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheUnstarted();
        Configuration c = cache.getConfiguration();
        c.setCacheLoaderConfig(this.getCacheLoaderConfig(true, passivationEnabled));
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheSPI<Object, Object> createCache() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheUnstarted();
        cache.create();
        cache.start();
        return cache;
    }

    protected void destroyCache(Cache<Object, Object> c) {
        TestingUtil.killCaches(c);
    }

    protected CacheSPI createPessimisticCache() throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = cache.getConfiguration();
        c.setClusterName("name");
        c.setStateRetrievalTimeout(5000L);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheSPI createPessimisticCacheLocal() throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = cache.getConfiguration();
        c.setClusterName("name");
        c.setStateRetrievalTimeout(5000L);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.create();
        cache.start();
        return cache;
    }

    protected CacheSPI createReplicatedCache(Configuration.CacheMode mode) throws Exception {
        return this.createReplicatedCache("test", mode);
    }

    protected CacheSPI createReplicatedCache(String name, Configuration.CacheMode mode) throws Exception {
        return this.createReplicatedCache(name, mode, true);
    }

    protected CacheSPI<Object, Object> createReplicatedCache(String name, Configuration.CacheMode mode, boolean start) throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = cache.getConfiguration();
        c.setClusterName(name);
        c.setStateRetrievalTimeout(5000L);
        c.setCacheMode(mode);
        if (mode == Configuration.CacheMode.REPL_SYNC) {
            c.setSyncCommitPhase(true);
            c.setSyncRollbackPhase(true);
        }
        c.setNodeLockingScheme("OPTIMISTIC");
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        if (start) {
            cache.create();
            cache.start();
        }
        return cache;
    }

    protected CacheSPI createReplicatedCacheWithLoader(boolean shared, Configuration.CacheMode cacheMode) throws Exception {
        return this.createReplicatedCacheWithLoader("temp-loader", shared, cacheMode);
    }

    protected CacheSPI<Object, Object> createReplicatedCacheWithLoader(boolean shared) throws Exception {
        return this.createReplicatedCacheWithLoader("temp-loader", shared, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheSPI createReplicatedCacheWithLoader(String name, boolean shared) throws Exception {
        return this.createReplicatedCacheWithLoader(name, shared, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheSPI<Object, Object> createReplicatedCacheWithLoader(String name, boolean shared, Configuration.CacheMode cacheMode) throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = cache.getConfiguration();
        c.setClusterName(name);
        c.setStateRetrievalTimeout(5000L);
        c.setCacheMode(cacheMode);
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setNodeLockingScheme("OPTIMISTIC");
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.setCacheLoaderConfig(this.getCacheLoaderConfig(shared, false));
        cache.create();
        cache.start();
        return cache;
    }

    protected void randomSleep(int min, int max) {
        if (this.random == null) {
            this.random = new Random();
        }
        long l = -1L;
        while (l < (long)min) {
            l = this.random.nextInt(max);
        }
        TestingUtil.sleepThread(l);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TransactionManager mgr = TransactionSetup.getManager();
        try {
            if (mgr.getTransaction() != null) {
                mgr.rollback();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    protected void setAlteredInterceptorChain(Interceptor newLast, CacheSPI<Object, Object> spi) {
        spi.removeInterceptor(CacheMgmtInterceptor.class);
        spi.removeInterceptor(NotificationInterceptor.class);
        spi.removeInterceptor(OptimisticLockingInterceptor.class);
        spi.removeInterceptor(OptimisticValidatorInterceptor.class);
        spi.removeInterceptor(CallInterceptor.class);
        spi.addInterceptor(newLast, OptimisticNodeInterceptor.class);
    }

    protected List<MethodCall> injectDataVersion(List<MethodCall> modifications) {
        LinkedList<MethodCall> newList = new LinkedList<MethodCall>();
        for (MethodCall c : modifications) {
            Object[] oa = c.getArgs();
            Object[] na = new Object[oa.length + 1];
            System.out.println("*** " + oa.length);
            System.arraycopy(oa, 0, na, 0, oa.length);
            na[oa.length] = new DefaultDataVersion();
            newList.add(MethodCallFactory.create((int)MethodDeclarations.getVersionedMethodId((int)c.getMethodId()), (Object[])na));
        }
        return newList;
    }

    protected class DummyAddress
    implements Address {
        private static final long serialVersionUID = -2628268587640985944L;

        protected DummyAddress() {
        }

        public int compareTo(Object arg0) {
            return 0;
        }

        public void readFrom(DataInputStream arg0) {
        }

        public void writeTo(DataOutputStream arg0) {
        }

        public void readExternal(ObjectInput arg0) {
        }

        public void writeExternal(ObjectOutput arg0) {
        }

        public int size() {
            return 0;
        }

        public boolean isMulticastAddress() {
            return false;
        }
    }

    public abstract class ExceptionThread
    extends Thread {
        protected Exception exception;

        public void setException(Exception e) {
            this.exception = e;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

