/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NodeInterceptorGetKeyValTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TransactionManager mgr;
    private TestListener listener;
    private MockInterceptor dummy;

    @BeforeMethod
    public void setUp() throws Exception {
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = TestingUtil.findInterceptor(this.cache, OptimisticCreateIfNotExistsInterceptor.class);
        OptimisticNodeInterceptor nodeInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticNodeInterceptor.class);
        this.dummy = new MockInterceptor();
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (Interceptor)interceptor);
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    public void testTransactionGetKeyMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache.get("/one/two", (Object)"key1"));
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.begin();
        Transaction tx2 = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx2);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx2, true));
        AssertJUnit.assertNull((Object)this.cache.get("/one/two", (Object)"key1"));
        this.mgr.commit();
    }

    public void testTransactionGetKeyValOverwriteMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo2);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((Object)pojo2, (Object)this.cache.get("/one/two", (Object)"key1"));
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo2, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionGetKeyValOverwriteNullMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        this.cache.put("/one/two", (Object)"key1", null);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals(null, (Object)this.cache.get("/one/two", (Object)"key1"));
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTwoTransactionGetIsolationKeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache.get("/one/two", (Object)"key1"));
        this.mgr.suspend();
        this.mgr.begin();
        Transaction tx2 = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx2);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx2, true));
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        this.cache.put("/one/two", (Object)"key2", (Object)pojo2);
        AssertJUnit.assertEquals(null, (Object)this.cache.get("/one/two", (Object)"key1"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)this.cache.get("/one/two", (Object)"key2"));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        GlobalTransaction gtx2 = table.get(tx2);
        OptimisticTransactionEntry entry2 = (OptimisticTransactionEntry)table.get(gtx2);
        TransactionWorkspace workspace2 = entry2.getTransactionWorkSpace();
        this.mgr.commit();
        this.mgr.resume(tx);
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key2"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)workspace2.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace2.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals(null, (Object)workspace2.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)workspace2.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key2"));
        AssertJUnit.assertTrue((boolean)entry2.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry2.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }
}

