/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.LockReportInterceptor;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class OptimisticLockInterceptorTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private LockReportInterceptor lri;
    private Fqn parent = Fqn.fromString((String)"/parent");
    private Fqn child = Fqn.fromString((String)"/parent/child");
    private TransactionManager tm;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.cache = this.createCache();
        this.lri = new LockReportInterceptor();
        this.lri.setCache(this.cache);
        TestingUtil.injectInterceptor(this.cache, (Interceptor)this.lri, OptimisticLockingInterceptor.class);
        this.cache.put(this.child, (Object)"key", (Object)"value");
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        this.cache.stop();
    }

    public void testPut() throws Exception {
        this.tm.begin();
        this.cache.put(this.child, (Object)"key2", (Object)"value2");
        this.lri.reset();
        this.lri.expectsReadLock(Fqn.ROOT);
        this.lri.expectsReadLock(this.parent);
        this.lri.expectsWriteLock(this.child);
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testGet() throws Exception {
        this.tm.begin();
        this.cache.get(this.child, (Object)"key2");
        this.lri.reset();
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testRemove() throws Exception {
        this.tm.begin();
        this.cache.remove(this.child, (Object)"key2");
        this.lri.reset();
        this.lri.expectsReadLock(Fqn.ROOT);
        this.lri.expectsReadLock(this.parent);
        this.lri.expectsWriteLock(this.child);
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testPutLockParentForCIR() throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.cache.removeNode(this.parent);
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.put(this.child, (Object)"key2", (Object)"value2");
        this.lri.reset();
        this.lri.expectsReadLock(Fqn.ROOT);
        this.lri.expectsWriteLock(this.parent);
        this.lri.expectsWriteLock(this.child);
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testGetLockParentForCIR() throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.tm.begin();
        this.cache.get(this.child, (Object)"key2");
        this.lri.reset();
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testRemoveLockParentForCIR() throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.tm.begin();
        this.cache.removeNode(this.child);
        this.lri.reset();
        this.lri.expectsReadLock(Fqn.ROOT);
        this.lri.expectsWriteLock(this.parent);
        this.lri.expectsWriteLock(this.child);
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testPutNodeNotExists() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.tm.begin();
        this.cache.put(this.child, (Object)"key2", (Object)"value2");
        this.lri.reset();
        this.lri.expectsReadLock(Fqn.ROOT);
        this.lri.expectsWriteLock(this.parent);
        this.lri.expectsWriteLock(this.child);
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testGetNodeNotExists() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.tm.begin();
        this.cache.get(this.child, (Object)"key2");
        this.lri.reset();
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    public void testRemoveNodeNotExists() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.tm.begin();
        this.cache.remove(this.child, (Object)"key2");
        this.lri.reset();
        this.tm.commit();
        this.lri.assertReceivedExpectedLocks();
        this.assertNoStaleLocks();
    }

    private void assertNoStaleLocks() {
        assert (this.cache.getNumberOfLocksHeld() == 0);
    }
}

