/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Collections;
import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.CachePrinter;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ValidatorInterceptorTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TransactionManager mgr;
    private MockInterceptor dummy;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cache = this.createCacheWithListener();
        this.mgr = this.cache.getTransactionManager();
        InvocationContextInterceptor ici = TestingUtil.findInterceptor(this.cache, InvocationContextInterceptor.class);
        OptimisticValidatorInterceptor validateInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticValidatorInterceptor.class);
        OptimisticCreateIfNotExistsInterceptor interceptor = TestingUtil.findInterceptor(this.cache, OptimisticCreateIfNotExistsInterceptor.class);
        OptimisticNodeInterceptor nodeInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticNodeInterceptor.class);
        this.dummy = new MockInterceptor();
        ici.setNext((Interceptor)validateInterceptor);
        validateInterceptor.setNext((Interceptor)interceptor);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (Interceptor)ici);
        this.cache.addInterceptor((Interceptor)new ResetRemoteFlagInterceptor(), InvocationContextInterceptor.class);
        System.out.println("Interceptors: " + CachePrinter.printCacheInterceptors(this.cache));
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    public void testTransactionvalidateMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{gtx, entry.getModifications(), null, gtx.getAddress(), Boolean.FALSE});
        TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)prepareMethod.getMethod(), (Object)this.dummy.getCalled());
        this.mgr.commit();
    }

    public void testTransactionValidateFailureMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        workspace.getNode(Fqn.fromString((String)"/one/two")).getNode().setVersion((DataVersion)new DefaultDataVersion(2L));
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{gtx, entry.getModifications(), null, gtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        this.mgr.commit();
    }

    public void testTransactionValidateCommitMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", Collections.singletonMap("key1", pojo));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{gtx, entry.getModifications(), null, gtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{gtx});
        TestingUtil.getRemoteDelegate(this.cache)._replicate(commitMethod);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals((Object)commitMethod.getMethod(), (Object)this.dummy.getCalled());
        NodeSPI node = workspace.getNode(Fqn.ROOT).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        this.mgr.commit();
    }

    public void testTransactionValidateFailRemoteCommitMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{gtx, entry.getModifications(), null, gtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{gtx});
        TestingUtil.getRemoteDelegate(this.cache)._replicate(commitMethod);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals((Object)commitMethod.getMethod(), (Object)this.dummy.getCalled());
        NodeSPI node = workspace.getNode(Fqn.fromString((String)"/")).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)this.cache.exists(node.getFqn()));
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)this.cache.exists(node.getFqn()));
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        this.mgr.commit();
    }

    public void testTransactionValidateRollbackMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{gtx, entry.getModifications(), null, gtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        MethodCall rollbackMethod = MethodCallFactory.create((int)12, (Object[])new Object[]{gtx});
        TestingUtil.getRemoteDelegate(this.cache)._replicate(rollbackMethod);
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        this.mgr.commit();
    }

    public static class ResetRemoteFlagInterceptor
    extends Interceptor {
        public Object invoke(InvocationContext ctx) throws Throwable {
            this.log.trace((Object)("Setting isRemote on gtx " + ctx.getGlobalTransaction() + " to true"));
            ctx.getGlobalTransaction().setRemote(true);
            return this.nextInterceptor(ctx);
        }
    }
}

